/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse;

public class ListCapacityReservationsIterable
implements SdkIterable<ListCapacityReservationsResponse> {
    private final AthenaClient client;
    private final ListCapacityReservationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCapacityReservationsIterable(AthenaClient client, ListCapacityReservationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCapacityReservationsResponseFetcher();
    }

    public Iterator<ListCapacityReservationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCapacityReservationsResponseFetcher
    implements SyncPageFetcher<ListCapacityReservationsResponse> {
        private ListCapacityReservationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCapacityReservationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCapacityReservationsResponse nextPage(ListCapacityReservationsResponse previousPage) {
            if (previousPage == null) {
                return ListCapacityReservationsIterable.this.client.listCapacityReservations(ListCapacityReservationsIterable.this.firstRequest);
            }
            return ListCapacityReservationsIterable.this.client.listCapacityReservations((ListCapacityReservationsRequest)((Object)ListCapacityReservationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

