/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableObjectsRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, GetTableObjectsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetTableObjectsRequest.getter(GetTableObjectsRequest::catalogId)).setter(GetTableObjectsRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(GetTableObjectsRequest.getter(GetTableObjectsRequest::databaseName)).setter(GetTableObjectsRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(GetTableObjectsRequest.getter(GetTableObjectsRequest::tableName)).setter(GetTableObjectsRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionId").getter(GetTableObjectsRequest.getter(GetTableObjectsRequest::transactionId)).setter(GetTableObjectsRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()}).build();
    private static final SdkField<Instant> QUERY_AS_OF_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("QueryAsOfTime").getter(GetTableObjectsRequest.getter(GetTableObjectsRequest::queryAsOfTime)).setter(GetTableObjectsRequest.setter(Builder::queryAsOfTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAsOfTime").build()}).build();
    private static final SdkField<String> PARTITION_PREDICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartitionPredicate").getter(GetTableObjectsRequest.getter(GetTableObjectsRequest::partitionPredicate)).setter(GetTableObjectsRequest.setter(Builder::partitionPredicate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionPredicate").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetTableObjectsRequest.getter(GetTableObjectsRequest::maxResults)).setter(GetTableObjectsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTableObjectsRequest.getter(GetTableObjectsRequest::nextToken)).setter(GetTableObjectsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, TRANSACTION_ID_FIELD, QUERY_AS_OF_TIME_FIELD, PARTITION_PREDICATE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTableObjectsRequest.memberNameToFieldInitializer();
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final String transactionId;
    private final Instant queryAsOfTime;
    private final String partitionPredicate;
    private final Integer maxResults;
    private final String nextToken;

    private GetTableObjectsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.transactionId = builder.transactionId;
        this.queryAsOfTime = builder.queryAsOfTime;
        this.partitionPredicate = builder.partitionPredicate;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final Instant queryAsOfTime() {
        return this.queryAsOfTime;
    }

    public final String partitionPredicate() {
        return this.partitionPredicate;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAsOfTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionPredicate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableObjectsRequest)) {
            return false;
        }
        GetTableObjectsRequest other = (GetTableObjectsRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.queryAsOfTime(), other.queryAsOfTime()) && Objects.equals(this.partitionPredicate(), other.partitionPredicate()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableObjectsRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("TransactionId", (Object)this.transactionId()).add("QueryAsOfTime", (Object)this.queryAsOfTime()).add("PartitionPredicate", (Object)this.partitionPredicate()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "QueryAsOfTime": {
                return Optional.ofNullable(clazz.cast(this.queryAsOfTime()));
            }
            case "PartitionPredicate": {
                return Optional.ofNullable(clazz.cast(this.partitionPredicate()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("TransactionId", TRANSACTION_ID_FIELD);
        map.put("QueryAsOfTime", QUERY_AS_OF_TIME_FIELD);
        map.put("PartitionPredicate", PARTITION_PREDICATE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableObjectsRequest, T> g) {
        return obj -> g.apply((GetTableObjectsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private String transactionId;
        private Instant queryAsOfTime;
        private String partitionPredicate;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableObjectsRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.transactionId(model.transactionId);
            this.queryAsOfTime(model.queryAsOfTime);
            this.partitionPredicate(model.partitionPredicate);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Instant getQueryAsOfTime() {
            return this.queryAsOfTime;
        }

        public final void setQueryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
        }

        @Override
        public final Builder queryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
            return this;
        }

        public final String getPartitionPredicate() {
            return this.partitionPredicate;
        }

        public final void setPartitionPredicate(String partitionPredicate) {
            this.partitionPredicate = partitionPredicate;
        }

        @Override
        public final Builder partitionPredicate(String partitionPredicate) {
            this.partitionPredicate = partitionPredicate;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTableObjectsRequest build() {
            return new GetTableObjectsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableObjectsRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder transactionId(String var1);

        public Builder queryAsOfTime(Instant var1);

        public Builder partitionPredicate(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

