/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.LFTagExpression;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsResponse;

public class ListLFTagExpressionsIterable
implements SdkIterable<ListLfTagExpressionsResponse> {
    private final LakeFormationClient client;
    private final ListLfTagExpressionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLFTagExpressionsIterable(LakeFormationClient client, ListLfTagExpressionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLfTagExpressionsResponseFetcher();
    }

    public Iterator<ListLfTagExpressionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LFTagExpression> lfTagExpressions() {
        Function<ListLfTagExpressionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lfTagExpressions() != null) {
                return response.lfTagExpressions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLfTagExpressionsResponseFetcher
    implements SyncPageFetcher<ListLfTagExpressionsResponse> {
        private ListLfTagExpressionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLfTagExpressionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLfTagExpressionsResponse nextPage(ListLfTagExpressionsResponse previousPage) {
            if (previousPage == null) {
                return ListLFTagExpressionsIterable.this.client.listLFTagExpressions(ListLFTagExpressionsIterable.this.firstRequest);
            }
            return ListLFTagExpressionsIterable.this.client.listLFTagExpressions((ListLfTagExpressionsRequest)((Object)ListLFTagExpressionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

