/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssooidc.model.AwsAdditionalDetails;
import software.amazon.awssdk.services.ssooidc.model.ScopesCopier;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTokenWithIamResponse
extends SsoOidcResponse
implements ToCopyableBuilder<Builder, CreateTokenWithIamResponse> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessToken").getter(CreateTokenWithIamResponse.getter(CreateTokenWithIamResponse::accessToken)).setter(CreateTokenWithIamResponse.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenType").getter(CreateTokenWithIamResponse.getter(CreateTokenWithIamResponse::tokenType)).setter(CreateTokenWithIamResponse.setter(Builder::tokenType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenType").build()}).build();
    private static final SdkField<Integer> EXPIRES_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("expiresIn").getter(CreateTokenWithIamResponse.getter(CreateTokenWithIamResponse::expiresIn)).setter(CreateTokenWithIamResponse.setter(Builder::expiresIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("refreshToken").getter(CreateTokenWithIamResponse.getter(CreateTokenWithIamResponse::refreshToken)).setter(CreateTokenWithIamResponse.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()}).build();
    private static final SdkField<String> ID_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idToken").getter(CreateTokenWithIamResponse.getter(CreateTokenWithIamResponse::idToken)).setter(CreateTokenWithIamResponse.setter(Builder::idToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idToken").build()}).build();
    private static final SdkField<String> ISSUED_TOKEN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuedTokenType").getter(CreateTokenWithIamResponse.getter(CreateTokenWithIamResponse::issuedTokenType)).setter(CreateTokenWithIamResponse.setter(Builder::issuedTokenType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuedTokenType").build()}).build();
    private static final SdkField<List<String>> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scope").getter(CreateTokenWithIamResponse.getter(CreateTokenWithIamResponse::scope)).setter(CreateTokenWithIamResponse.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsAdditionalDetails> AWS_ADDITIONAL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsAdditionalDetails").getter(CreateTokenWithIamResponse.getter(CreateTokenWithIamResponse::awsAdditionalDetails)).setter(CreateTokenWithIamResponse.setter(Builder::awsAdditionalDetails)).constructor(AwsAdditionalDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAdditionalDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, TOKEN_TYPE_FIELD, EXPIRES_IN_FIELD, REFRESH_TOKEN_FIELD, ID_TOKEN_FIELD, ISSUED_TOKEN_TYPE_FIELD, SCOPE_FIELD, AWS_ADDITIONAL_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTokenWithIamResponse.memberNameToFieldInitializer();
    private final String accessToken;
    private final String tokenType;
    private final Integer expiresIn;
    private final String refreshToken;
    private final String idToken;
    private final String issuedTokenType;
    private final List<String> scope;
    private final AwsAdditionalDetails awsAdditionalDetails;

    private CreateTokenWithIamResponse(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.tokenType = builder.tokenType;
        this.expiresIn = builder.expiresIn;
        this.refreshToken = builder.refreshToken;
        this.idToken = builder.idToken;
        this.issuedTokenType = builder.issuedTokenType;
        this.scope = builder.scope;
        this.awsAdditionalDetails = builder.awsAdditionalDetails;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String tokenType() {
        return this.tokenType;
    }

    public final Integer expiresIn() {
        return this.expiresIn;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final String idToken() {
        return this.idToken;
    }

    public final String issuedTokenType() {
        return this.issuedTokenType;
    }

    public final boolean hasScope() {
        return this.scope != null && !(this.scope instanceof SdkAutoConstructList);
    }

    public final List<String> scope() {
        return this.scope;
    }

    public final AwsAdditionalDetails awsAdditionalDetails() {
        return this.awsAdditionalDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.idToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedTokenType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScope() ? this.scope() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAdditionalDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenWithIamResponse)) {
            return false;
        }
        CreateTokenWithIamResponse other = (CreateTokenWithIamResponse)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.tokenType(), other.tokenType()) && Objects.equals(this.expiresIn(), other.expiresIn()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.idToken(), other.idToken()) && Objects.equals(this.issuedTokenType(), other.issuedTokenType()) && this.hasScope() == other.hasScope() && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.awsAdditionalDetails(), other.awsAdditionalDetails());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTokenWithIamResponse").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("TokenType", (Object)this.tokenType()).add("ExpiresIn", (Object)this.expiresIn()).add("RefreshToken", (Object)(this.refreshToken() == null ? null : "*** Sensitive Data Redacted ***")).add("IdToken", (Object)(this.idToken() == null ? null : "*** Sensitive Data Redacted ***")).add("IssuedTokenType", (Object)this.issuedTokenType()).add("Scope", this.hasScope() ? this.scope() : null).add("AwsAdditionalDetails", (Object)this.awsAdditionalDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "tokenType": {
                return Optional.ofNullable(clazz.cast(this.tokenType()));
            }
            case "expiresIn": {
                return Optional.ofNullable(clazz.cast(this.expiresIn()));
            }
            case "refreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "idToken": {
                return Optional.ofNullable(clazz.cast(this.idToken()));
            }
            case "issuedTokenType": {
                return Optional.ofNullable(clazz.cast(this.issuedTokenType()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "awsAdditionalDetails": {
                return Optional.ofNullable(clazz.cast(this.awsAdditionalDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("tokenType", TOKEN_TYPE_FIELD);
        map.put("expiresIn", EXPIRES_IN_FIELD);
        map.put("refreshToken", REFRESH_TOKEN_FIELD);
        map.put("idToken", ID_TOKEN_FIELD);
        map.put("issuedTokenType", ISSUED_TOKEN_TYPE_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("awsAdditionalDetails", AWS_ADDITIONAL_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenWithIamResponse, T> g) {
        return obj -> g.apply((CreateTokenWithIamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoOidcResponse.BuilderImpl
    implements Builder {
        private String accessToken;
        private String tokenType;
        private Integer expiresIn;
        private String refreshToken;
        private String idToken;
        private String issuedTokenType;
        private List<String> scope = DefaultSdkAutoConstructList.getInstance();
        private AwsAdditionalDetails awsAdditionalDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenWithIamResponse model) {
            super(model);
            this.accessToken(model.accessToken);
            this.tokenType(model.tokenType);
            this.expiresIn(model.expiresIn);
            this.refreshToken(model.refreshToken);
            this.idToken(model.idToken);
            this.issuedTokenType(model.issuedTokenType);
            this.scope(model.scope);
            this.awsAdditionalDetails(model.awsAdditionalDetails);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getTokenType() {
            return this.tokenType;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final Integer getExpiresIn() {
            return this.expiresIn;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getIdToken() {
            return this.idToken;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public final String getIssuedTokenType() {
            return this.issuedTokenType;
        }

        public final void setIssuedTokenType(String issuedTokenType) {
            this.issuedTokenType = issuedTokenType;
        }

        @Override
        public final Builder issuedTokenType(String issuedTokenType) {
            this.issuedTokenType = issuedTokenType;
            return this;
        }

        public final Collection<String> getScope() {
            if (this.scope instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scope;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
        }

        @Override
        public final Builder scope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(String ... scope) {
            this.scope(Arrays.asList(scope));
            return this;
        }

        public final AwsAdditionalDetails.Builder getAwsAdditionalDetails() {
            return this.awsAdditionalDetails != null ? this.awsAdditionalDetails.toBuilder() : null;
        }

        public final void setAwsAdditionalDetails(AwsAdditionalDetails.BuilderImpl awsAdditionalDetails) {
            this.awsAdditionalDetails = awsAdditionalDetails != null ? awsAdditionalDetails.build() : null;
        }

        @Override
        public final Builder awsAdditionalDetails(AwsAdditionalDetails awsAdditionalDetails) {
            this.awsAdditionalDetails = awsAdditionalDetails;
            return this;
        }

        @Override
        public CreateTokenWithIamResponse build() {
            return new CreateTokenWithIamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoOidcResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTokenWithIamResponse> {
        public Builder accessToken(String var1);

        public Builder tokenType(String var1);

        public Builder expiresIn(Integer var1);

        public Builder refreshToken(String var1);

        public Builder idToken(String var1);

        public Builder issuedTokenType(String var1);

        public Builder scope(Collection<String> var1);

        public Builder scope(String ... var1);

        public Builder awsAdditionalDetails(AwsAdditionalDetails var1);

        default public Builder awsAdditionalDetails(Consumer<AwsAdditionalDetails.Builder> awsAdditionalDetails) {
            return this.awsAdditionalDetails((AwsAdditionalDetails)((AwsAdditionalDetails.Builder)AwsAdditionalDetails.builder().applyMutation(awsAdditionalDetails)).build());
        }
    }
}

