/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AccountInfo;
import software.amazon.awssdk.services.datazone.model.AccountInfoListCopier;
import software.amazon.awssdk.services.datazone.model.CustomAccountPoolHandler;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountSource> {
    private static final SdkField<List<AccountInfo>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accounts").getter(AccountSource.getter(AccountSource::accounts)).setter(AccountSource.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomAccountPoolHandler> CUSTOM_ACCOUNT_POOL_HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customAccountPoolHandler").getter(AccountSource.getter(AccountSource::customAccountPoolHandler)).setter(AccountSource.setter(Builder::customAccountPoolHandler)).constructor(CustomAccountPoolHandler::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAccountPoolHandler").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, CUSTOM_ACCOUNT_POOL_HANDLER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AccountInfo> accounts;
    private final CustomAccountPoolHandler customAccountPoolHandler;
    private final Type type;

    private AccountSource(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.customAccountPoolHandler = builder.customAccountPoolHandler;
        this.type = builder.type;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<AccountInfo> accounts() {
        return this.accounts;
    }

    public final CustomAccountPoolHandler customAccountPoolHandler() {
        return this.customAccountPoolHandler;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customAccountPoolHandler());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSource)) {
            return false;
        }
        AccountSource other = (AccountSource)obj;
        return this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts()) && Objects.equals(this.customAccountPoolHandler(), other.customAccountPoolHandler());
    }

    public final String toString() {
        return ToString.builder((String)"AccountSource").add("Accounts", this.hasAccounts() ? this.accounts() : null).add("CustomAccountPoolHandler", (Object)this.customAccountPoolHandler()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
            case "customAccountPoolHandler": {
                return Optional.ofNullable(clazz.cast(this.customAccountPoolHandler()));
            }
        }
        return Optional.empty();
    }

    public static AccountSource fromAccounts(List<AccountInfo> accounts) {
        return (AccountSource)AccountSource.builder().accounts(accounts).build();
    }

    public static AccountSource fromCustomAccountPoolHandler(CustomAccountPoolHandler customAccountPoolHandler) {
        return (AccountSource)AccountSource.builder().customAccountPoolHandler(customAccountPoolHandler).build();
    }

    public static AccountSource fromCustomAccountPoolHandler(Consumer<CustomAccountPoolHandler.Builder> customAccountPoolHandler) {
        CustomAccountPoolHandler.Builder builder = CustomAccountPoolHandler.builder();
        customAccountPoolHandler.accept(builder);
        return AccountSource.fromCustomAccountPoolHandler((CustomAccountPoolHandler)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accounts", ACCOUNTS_FIELD);
        map.put("customAccountPoolHandler", CUSTOM_ACCOUNT_POOL_HANDLER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountSource, T> g) {
        return obj -> g.apply((AccountSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AccountInfo> accounts = DefaultSdkAutoConstructList.getInstance();
        private CustomAccountPoolHandler customAccountPoolHandler;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSource model) {
            this.accounts(model.accounts);
            this.customAccountPoolHandler(model.customAccountPoolHandler);
        }

        public final List<AccountInfo.Builder> getAccounts() {
            List<AccountInfo.Builder> result = AccountInfoListCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<AccountInfo.BuilderImpl> accounts) {
            List<AccountInfo> oldValue = this.accounts;
            this.accounts = AccountInfoListCopier.copyFromBuilder(accounts);
            this.handleUnionValueChange(Type.ACCOUNTS, oldValue, this.accounts);
        }

        @Override
        public final Builder accounts(Collection<AccountInfo> accounts) {
            List<AccountInfo> oldValue = this.accounts;
            this.accounts = AccountInfoListCopier.copy(accounts);
            this.handleUnionValueChange(Type.ACCOUNTS, oldValue, this.accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(AccountInfo ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<AccountInfo.Builder> ... accounts) {
            this.accounts(Stream.of(accounts).map(c -> (AccountInfo)((AccountInfo.Builder)AccountInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CustomAccountPoolHandler.Builder getCustomAccountPoolHandler() {
            return this.customAccountPoolHandler != null ? this.customAccountPoolHandler.toBuilder() : null;
        }

        public final void setCustomAccountPoolHandler(CustomAccountPoolHandler.BuilderImpl customAccountPoolHandler) {
            CustomAccountPoolHandler oldValue = this.customAccountPoolHandler;
            this.customAccountPoolHandler = customAccountPoolHandler != null ? customAccountPoolHandler.build() : null;
            this.handleUnionValueChange(Type.CUSTOM_ACCOUNT_POOL_HANDLER, oldValue, this.customAccountPoolHandler);
        }

        @Override
        public final Builder customAccountPoolHandler(CustomAccountPoolHandler customAccountPoolHandler) {
            CustomAccountPoolHandler oldValue = this.customAccountPoolHandler;
            this.customAccountPoolHandler = customAccountPoolHandler;
            this.handleUnionValueChange(Type.CUSTOM_ACCOUNT_POOL_HANDLER, oldValue, this.customAccountPoolHandler);
            return this;
        }

        public AccountSource build() {
            return new AccountSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        ACCOUNTS,
        CUSTOM_ACCOUNT_POOL_HANDLER,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountSource> {
        public Builder accounts(Collection<AccountInfo> var1);

        public Builder accounts(AccountInfo ... var1);

        public Builder accounts(Consumer<AccountInfo.Builder> ... var1);

        public Builder customAccountPoolHandler(CustomAccountPoolHandler var1);

        default public Builder customAccountPoolHandler(Consumer<CustomAccountPoolHandler.Builder> customAccountPoolHandler) {
            return this.customAccountPoolHandler((CustomAccountPoolHandler)((CustomAccountPoolHandler.Builder)CustomAccountPoolHandler.builder().applyMutation(customAccountPoolHandler)).build());
        }
    }
}

