/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.async;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class ResponsePublisher<ResponseT extends SdkResponse>
implements SdkPublisher<ByteBuffer> {
    private static final Logger log = Logger.loggerFor(ResponsePublisher.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(60L);
    private final ResponseT response;
    private final SdkPublisher<ByteBuffer> publisher;
    private ScheduledFuture<?> timeoutTask;
    private volatile boolean subscribed = false;

    public ResponsePublisher(ResponseT response, SdkPublisher<ByteBuffer> publisher) {
        this(response, publisher, null);
    }

    public ResponsePublisher(ResponseT response, SdkPublisher<ByteBuffer> publisher, Duration timeout) {
        this.response = (SdkResponse)Validate.paramNotNull(response, (String)"response");
        this.publisher = (SdkPublisher)Validate.paramNotNull(publisher, (String)"publisher");
        Duration resolvedTimeout = timeout != null ? timeout : DEFAULT_TIMEOUT;
        this.scheduleTimeoutTask(resolvedTimeout);
    }

    public ResponseT response() {
        return this.response;
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        this.subscribed = true;
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel(false);
        }
        this.publisher.subscribe(subscriber);
    }

    private void scheduleTimeoutTask(Duration timeout) {
        if (timeout.equals(Duration.ZERO) || timeout.isNegative()) {
            return;
        }
        long timeoutInMillis = timeout.toMillis();
        this.timeoutTask = TimeoutScheduler.INSTANCE.schedule(() -> {
            if (!this.subscribed) {
                log.debug(() -> String.format("Publisher was not consumed before timeout of [%d] milliseconds, cancelling subscription and closing connection.", timeoutInMillis));
                this.publisher.subscribe(new CancellingSubscriber());
            }
        }, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return ToString.builder((String)"ResponsePublisher").add("response", this.response).add("publisher", this.publisher).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponsePublisher that = (ResponsePublisher)o;
        if (!Objects.equals(this.response, that.response)) {
            return false;
        }
        return Objects.equals(this.publisher, that.publisher);
    }

    public int hashCode() {
        int result = this.response != null ? ((SdkResponse)this.response).hashCode() : 0;
        result = 31 * result + (this.publisher != null ? this.publisher.hashCode() : 0);
        return result;
    }

    @SdkTestInternalApi
    public boolean hasTimeoutTask() {
        return this.timeoutTask != null;
    }

    @SdkTestInternalApi
    public boolean timeoutTaskDoneOrCancelled() {
        return this.timeoutTask != null && this.timeoutTask.isDone();
    }

    private static final class TimeoutScheduler {
        static final ScheduledExecutorService INSTANCE = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r, "response-publisher-timeout-scheduler");
            t.setDaemon(true);
            return t;
        });

        private TimeoutScheduler() {
        }
    }

    private static class CancellingSubscriber
    implements Subscriber<ByteBuffer> {
        private CancellingSubscriber() {
        }

        public void onSubscribe(Subscription s) {
            s.cancel();
        }

        public void onNext(ByteBuffer b) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    }
}

