/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.endpointdiscovery;

import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryEndpoint;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryFailedException;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;

@SdkProtectedApi
public final class EndpointDiscoveryRefreshCache {
    private final Map<String, EndpointDiscoveryEndpoint> cache = new ConcurrentHashMap<String, EndpointDiscoveryEndpoint>();
    private final EndpointDiscoveryCacheLoader client;

    private EndpointDiscoveryRefreshCache(EndpointDiscoveryCacheLoader client) {
        this.client = client;
    }

    public static EndpointDiscoveryRefreshCache create(EndpointDiscoveryCacheLoader client) {
        return new EndpointDiscoveryRefreshCache(client);
    }

    public URI get(String accessKey, EndpointDiscoveryRequest request) {
        String key = this.getKey(accessKey, request);
        EndpointDiscoveryEndpoint endpoint = this.cache.get(key);
        if (endpoint == null && request.required()) {
            return this.cache.computeIfAbsent(key, k -> this.getAndJoin(request)).endpoint();
        }
        return this.returnCachedOrDefaultEndpoint(key, endpoint, request);
    }

    public CompletableFuture<URI> getAsync(String accessKey, EndpointDiscoveryRequest request) {
        String key = this.getKey(accessKey, request);
        EndpointDiscoveryEndpoint endpoint = this.cache.get(key);
        if (endpoint == null && request.required()) {
            return this.discoverEndpointHandler(key, request);
        }
        return CompletableFuture.completedFuture(this.returnCachedOrDefaultEndpoint(key, endpoint, request));
    }

    private EndpointDiscoveryEndpoint getAndJoin(EndpointDiscoveryRequest request) {
        try {
            return this.discoverEndpoint(request).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw EndpointDiscoveryFailedException.create(e);
        }
        catch (ExecutionException e) {
            throw EndpointDiscoveryFailedException.create(e.getCause());
        }
    }

    private void refreshCacheAsync(EndpointDiscoveryRequest request, String key) {
        this.discoverEndpoint(request).thenApply(v -> this.cache.put(key, (EndpointDiscoveryEndpoint)v));
    }

    public CompletableFuture<EndpointDiscoveryEndpoint> discoverEndpoint(EndpointDiscoveryRequest request) {
        return this.client.discoverEndpoint(request);
    }

    public void evict(String key) {
        this.cache.remove(key);
    }

    private String getKey(String accessKey, EndpointDiscoveryRequest request) {
        String key = accessKey;
        if (key == null) {
            key = "";
        }
        if (request.cacheKey().isPresent()) {
            key = key + ":" + request.cacheKey().get();
        }
        return key;
    }

    private CompletableFuture<URI> discoverEndpointHandler(String key, EndpointDiscoveryRequest request) {
        return this.discoverEndpoint(request).handle((endpointDiscoveryEndpoint, throwable) -> {
            if (throwable != null) {
                throw EndpointDiscoveryFailedException.create(throwable.getCause());
            }
            return this.cache.computeIfAbsent(key, k -> endpointDiscoveryEndpoint).endpoint();
        });
    }

    private URI returnCachedOrDefaultEndpoint(String key, EndpointDiscoveryEndpoint endpoint, EndpointDiscoveryRequest request) {
        EndpointDiscoveryEndpoint tempEndpoint = EndpointDiscoveryEndpoint.builder().endpoint(request.defaultEndpoint()).expirationTime(Instant.now().plusSeconds(60L)).build();
        if (endpoint == null) {
            EndpointDiscoveryEndpoint previousValue = this.cache.putIfAbsent(key, tempEndpoint);
            if (previousValue != null) {
                return previousValue.endpoint();
            }
            this.refreshCacheAsync(request, key);
            return tempEndpoint.endpoint();
        }
        if (endpoint.expirationTime().isBefore(Instant.now())) {
            this.cache.put(key, endpoint.toBuilder().expirationTime(Instant.now().plusSeconds(60L)).build());
            this.refreshCacheAsync(request, key);
        }
        return endpoint.endpoint();
    }
}

