/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import software.amazon.awssdk.core.internal.http.pipeline.RequestToResponsePipeline;
import software.amazon.awssdk.core.internal.http.pipeline.stages.utils.RetryableStageHelper;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;

@SdkInternalApi
public final class RetryableStage<OutputT>
implements RequestToResponsePipeline<OutputT> {
    private static final String RETRY_AFTER_HEADER = "Retry-After";
    private final RequestPipeline<SdkHttpFullRequest, Response<OutputT>> requestPipeline;
    private final HttpClientDependencies dependencies;

    public RetryableStage(HttpClientDependencies dependencies, RequestPipeline<SdkHttpFullRequest, Response<OutputT>> requestPipeline) {
        this.dependencies = dependencies;
        this.requestPipeline = requestPipeline;
    }

    @Override
    public Response<OutputT> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        RetryableStageHelper retryableStageHelper = new RetryableStageHelper(request, context, this.dependencies);
        Duration initialDelay = retryableStageHelper.acquireInitialToken();
        TimeUnit.MILLISECONDS.sleep(initialDelay.toMillis());
        while (true) {
            try {
                retryableStageHelper.startingAttempt();
                Response<OutputT> response = this.executeRequest(retryableStageHelper, context);
                retryableStageHelper.recordAttemptSucceeded();
                return response;
            }
            catch (IOException | SdkException | SdkExceptionWithRetryAfterHint e) {
                Exception throwable = e;
                if (e instanceof SdkExceptionWithRetryAfterHint) {
                    SdkExceptionWithRetryAfterHint wrapper = (SdkExceptionWithRetryAfterHint)e;
                    throwable = wrapper.cause();
                }
                retryableStageHelper.setLastException(throwable);
                Duration suggestedDelay = this.suggestedDelay(e);
                Optional<Duration> backoffDelay = retryableStageHelper.tryRefreshToken(suggestedDelay);
                if (backoffDelay.isPresent()) {
                    Duration delay = backoffDelay.get();
                    retryableStageHelper.logBackingOff(delay);
                    TimeUnit.MILLISECONDS.sleep(delay.toMillis());
                    continue;
                }
                throw retryableStageHelper.retryPolicyDisallowedRetryException();
            }
            break;
        }
    }

    private Duration suggestedDelay(Exception e) {
        if (e instanceof SdkExceptionWithRetryAfterHint) {
            SdkExceptionWithRetryAfterHint except = (SdkExceptionWithRetryAfterHint)e;
            return Duration.ofSeconds(except.retryAfter());
        }
        return Duration.ZERO;
    }

    private Response<OutputT> executeRequest(RetryableStageHelper retryableStageHelper, RequestExecutionContext context) throws Exception {
        retryableStageHelper.logSendingRequest();
        Response<OutputT> response = this.requestPipeline.execute(retryableStageHelper.requestToSend(), context);
        retryableStageHelper.setLastResponse((SdkHttpResponse)response.httpResponse());
        if (!response.isSuccess().booleanValue()) {
            retryableStageHelper.adjustClockIfClockSkew(response);
            throw this.responseException(response);
        }
        return response;
    }

    private RuntimeException responseException(Response<OutputT> response) {
        Optional<Integer> optionalRetryAfter = this.retryAfter(response.httpResponse());
        if (optionalRetryAfter.isPresent()) {
            return new SdkExceptionWithRetryAfterHint(optionalRetryAfter.get(), response.exception());
        }
        return response.exception();
    }

    private Optional<Integer> retryAfter(SdkHttpFullResponse response) {
        Optional optionalRetryAfterHeader = response.firstMatchingHeader(RETRY_AFTER_HEADER);
        if (optionalRetryAfterHeader.isPresent()) {
            String retryAfterHeader = (String)optionalRetryAfterHeader.get();
            try {
                return Optional.of(Integer.parseInt(retryAfterHeader));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    static class SdkExceptionWithRetryAfterHint
    extends RuntimeException {
        private final SdkException cause;
        private final int seconds;

        SdkExceptionWithRetryAfterHint(int seconds, SdkException cause) {
            this.seconds = seconds;
            this.cause = cause;
        }

        public int retryAfter() {
            return this.seconds;
        }

        public SdkException cause() {
            return this.cause;
        }

        public int seconds() {
            return this.seconds;
        }
    }
}

