/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.useragent;

import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.StringUtils;

@SdkProtectedApi
public final class UserAgentConstant {
    public static final String API_METADATA = "api";
    public static final String OS_METADATA = "os";
    public static final String LANG_METADATA = "lang";
    public static final String UA_METADATA = "ua";
    public static final String ENV_METADATA = "exec-env";
    public static final String JAVA_SDK_METADATA = "aws-sdk-java";
    public static final String FEATURE_METADATA = "ft";
    public static final String CONFIG_METADATA = "cfg";
    public static final String FRAMEWORK_METADATA = "lib";
    public static final String METADATA = "md";
    public static final String BUSINESS_METADATA = "m";
    public static final String INTERNAL_METADATA_MARKER = "internal";
    public static final String APP_ID = "app";
    public static final String UA_VERSION = "2.1";
    public static final String SLASH = "/";
    public static final String HASH = "#";
    public static final String SPACE = " ";
    public static final String COMMA = ",";
    public static final String IO = "io";
    public static final String HTTP = "http";
    public static final String RETRY_MODE = "retry-mode";
    public static final String AUTH_SOURCE = "auth-source";
    private static final String UA_DENYLIST_REGEX = "[() ,/:;<=>?@\\[\\]{}\\\\]";
    private static final Pattern UA_DENYLIST_PATTERN = Pattern.compile("[() ,/:;<=>?@\\[\\]{}\\\\]");
    private static final String UNKNOWN = "unknown";

    private UserAgentConstant() {
    }

    public static String field(String name, String value) {
        return UserAgentConstant.concat(name, StringUtils.trim((String)value), SLASH);
    }

    public static String uaPair(String name, String value) {
        return UserAgentConstant.concat(name, value, HASH);
    }

    public static String uaPairOrNull(String name, String value) {
        return value != null ? UserAgentConstant.uaPair(name, value) : null;
    }

    public static void appendFieldAndSpace(StringBuilder builder, String name, String value) {
        builder.append(name).append(SLASH).append(value);
        builder.append(SPACE);
    }

    public static void appendSpaceAndField(StringBuilder builder, String name, String value) {
        builder.append(SPACE);
        builder.append(name).append(SLASH).append(value);
    }

    public static void appendNonEmptyField(StringBuilder builder, String name, String value) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            UserAgentConstant.appendFieldAndSpace(builder, name, value);
        }
    }

    public static String sanitizeInput(String input) {
        return input == null ? UNKNOWN : UA_DENYLIST_PATTERN.matcher(input).replaceAll("_");
    }

    public static String concat(String prefix, String suffix, String separator) {
        return suffix != null && !suffix.isEmpty() ? prefix + separator + suffix : prefix;
    }
}

