/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.useragent;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.internal.useragent.UserAgentConstant;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public final class AdditionalMetadata {
    private final String name;
    private final String value;

    private AdditionalMetadata(BuilderImpl b) {
        this.name = (String)Validate.notNull((Object)b.name, (String)"name must not be null", (Object[])new Object[0]);
        this.value = (String)Validate.notNull((Object)b.value, (String)"value must not be null", (Object[])new Object[0]);
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return UserAgentConstant.field("md", UserAgentConstant.uaPair(this.name, this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalMetadata that = (AdditionalMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String value;

        private BuilderImpl() {
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public AdditionalMetadata build() {
            return new AdditionalMetadata(this);
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder value(String var1);

        public AdditionalMetadata build();
    }
}

