/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.waiters;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.internal.waiters.LegacyToNonLegacyAdapter;
import software.amazon.awssdk.core.internal.waiters.NonLegacyToLegacyAdapter;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class WaiterOverrideConfiguration
implements ToCopyableBuilder<Builder, WaiterOverrideConfiguration> {
    private final Integer maxAttempts;
    private final BackoffStrategy backoffStrategy;
    private final Duration waitTimeout;

    public WaiterOverrideConfiguration(Builder builder) {
        this.maxAttempts = Validate.isPositiveOrNull((Integer)builder.maxAttempts, (String)"maxAttempts");
        this.waitTimeout = Validate.isPositiveOrNull((Duration)builder.waitTimeout, (String)"waitTimeout");
        Validate.mutuallyExclusive((String)"Only one of backoffStrategy or backoffStrategyV2 may be used, but both where defined", (Object[])new Object[]{builder.backoffStrategy, builder.backoffStrategyV2});
        this.backoffStrategy = builder.backoffStrategyV2 != null ? builder.backoffStrategyV2 : (builder.backoffStrategy != null ? new LegacyToNonLegacyAdapter(builder.backoffStrategy) : null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Integer> maxAttempts() {
        return Optional.ofNullable(this.maxAttempts);
    }

    public Optional<software.amazon.awssdk.core.retry.backoff.BackoffStrategy> backoffStrategy() {
        if (this.backoffStrategy == null) {
            return Optional.empty();
        }
        if (this.backoffStrategy instanceof LegacyToNonLegacyAdapter) {
            return Optional.of(((LegacyToNonLegacyAdapter)this.backoffStrategy).adaptee());
        }
        return Optional.of(new NonLegacyToLegacyAdapter(this.backoffStrategy));
    }

    public Optional<BackoffStrategy> backoffStrategyV2() {
        return Optional.ofNullable(this.backoffStrategy);
    }

    public Optional<Duration> waitTimeout() {
        return Optional.ofNullable(this.waitTimeout);
    }

    public Builder toBuilder() {
        return new Builder().maxAttempts(this.maxAttempts).backoffStrategyV2(this.backoffStrategy).backoffStrategy(null).waitTimeout(this.waitTimeout);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaiterOverrideConfiguration that = (WaiterOverrideConfiguration)o;
        if (!Objects.equals(this.maxAttempts, that.maxAttempts)) {
            return false;
        }
        if (!Objects.equals(this.backoffStrategy, that.backoffStrategy)) {
            return false;
        }
        return Objects.equals(this.waitTimeout, that.waitTimeout);
    }

    public int hashCode() {
        int result = this.maxAttempts != null ? this.maxAttempts.hashCode() : 0;
        result = 31 * result + (this.backoffStrategy != null ? this.backoffStrategy.hashCode() : 0);
        result = 31 * result + (this.waitTimeout != null ? this.waitTimeout.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"WaiterOverrideConfiguration").add("maxAttempts", (Object)this.maxAttempts).add("waitTimeout", (Object)this.waitTimeout).add("backoffStrategy", (Object)this.backoffStrategy).build();
    }

    public static final class Builder
    implements CopyableBuilder<Builder, WaiterOverrideConfiguration> {
        private Integer maxAttempts;
        private Duration waitTimeout;
        private software.amazon.awssdk.core.retry.backoff.BackoffStrategy backoffStrategy;
        private BackoffStrategy backoffStrategyV2;

        private Builder() {
        }

        public Builder backoffStrategy(software.amazon.awssdk.core.retry.backoff.BackoffStrategy backoffStrategy) {
            this.backoffStrategy = backoffStrategy;
            return this;
        }

        public Builder backoffStrategyV2(BackoffStrategy backoffStrategy) {
            this.backoffStrategyV2 = backoffStrategy;
            return this;
        }

        public Builder maxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder waitTimeout(Duration waitTimeout) {
            this.waitTimeout = waitTimeout;
            return this;
        }

        public WaiterOverrideConfiguration build() {
            return new WaiterOverrideConfiguration(this);
        }
    }
}

