/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.polling;

import com.amazon.athena.client.polling.PollingStrategy;
import java.time.Duration;
import java.util.Objects;

public class BackoffPollingStrategy
implements PollingStrategy {
    private final long factor;
    private final Duration initialDelay;
    private final Duration maxDelay;

    public BackoffPollingStrategy(long factor, Duration initialDelay, Duration maxDelay) {
        this.factor = factor;
        this.initialDelay = initialDelay;
        this.maxDelay = maxDelay;
    }

    @Override
    public Duration nextDelay(Duration previousDelay) {
        if (previousDelay.isZero()) {
            return this.initialDelay;
        }
        Duration nextDelay = previousDelay.multipliedBy(this.factor);
        if (nextDelay.compareTo(this.maxDelay) > 0) {
            return this.maxDelay;
        }
        return nextDelay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackoffPollingStrategy that = (BackoffPollingStrategy)o;
        return this.factor == that.factor && Objects.equals(this.initialDelay, that.initialDelay) && Objects.equals(this.maxDelay, that.maxDelay);
    }

    public int hashCode() {
        return Objects.hash(this.factor, this.initialDelay, this.maxDelay);
    }
}

