/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.logging.AthenaLogger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;

public class AthenaMetadataParser {
    private static final AthenaLogger logger = AthenaLogger.of(AthenaMetadataParser.class);
    private static final int UPDATE_COUNT_FIELD_NUMBER = 3;
    private static final int COLUMN_FIELD_NUMBER = 4;
    private static final int CATALOG_NAME_FIELD_NUMBER = 1;
    private static final int SCHEMA_NAME_FIELD_NUMBER = 2;
    private static final int TABLE_NAME_FIELD_NUMBER = 3;
    private static final int NAME_FIELD_NUMBER = 4;
    private static final int LABEL_FIELD_NUMBER = 5;
    private static final int TYPE_FIELD_NUMBER = 6;
    private static final int PRECISION_FIELD_NUMBER = 7;
    private static final int SCALE_FIELD_NUMBER = 8;
    private static final int NULLABLE_FIELD_NUMBER = 9;
    private static final int CASE_SENSITIVE_FIELD_NUMBER = 10;

    public GetQueryResultsResponse parse(ByteBuffer buffer) throws ParseException {
        List<Field> fields = this.parseFields(buffer);
        logger.debug("Extracted {} ProtoBuf field(s) from Athena results metadata file", fields.size());
        Long updateCount = fields.stream().filter(topLevelField -> topLevelField.fieldNumber() == 3).map(Field::value).findFirst().orElse(null);
        logger.debug("Extracted update count of {} from Athena results metadata file", updateCount);
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        for (Field topLevelField2 : fields) {
            if (topLevelField2.fieldNumber() != 4) continue;
            ColumnInfo columnInfo = this.fieldToColumnInfo(topLevelField2);
            columns.add(columnInfo);
        }
        logger.debug("Extracted {} column(s) from Athena results metadata file", columns.size());
        GetQueryResultsResponse response = (GetQueryResultsResponse)GetQueryResultsResponse.builder().updateCount(updateCount).resultSet(b -> b.resultSetMetadata(bb -> bb.columnInfo((Collection)columns))).build();
        logger.trace("Constructed GetQueryResultsResponse from Athena query results metadata: {}", response);
        return response;
    }

    private ColumnInfo fieldToColumnInfo(Field columnField) throws ParseException {
        ColumnInfo.Builder columnBuilder = ColumnInfo.builder().precision(Integer.valueOf(0)).scale(Integer.valueOf(0));
        for (Field columnPropertyField : this.parseFields(ByteBuffer.wrap(columnField.contents()))) {
            this.populateColumnField(columnBuilder, columnPropertyField);
        }
        return (ColumnInfo)columnBuilder.build();
    }

    private void populateColumnField(ColumnInfo.Builder columnBuilder, Field columnPropertyField) {
        switch (columnPropertyField.fieldNumber()) {
            case 1: {
                columnBuilder.catalogName(this.fieldToString(columnPropertyField));
                break;
            }
            case 2: {
                columnBuilder.schemaName(this.fieldToString(columnPropertyField));
                break;
            }
            case 3: {
                columnBuilder.tableName(this.fieldToString(columnPropertyField));
                break;
            }
            case 4: {
                columnBuilder.name(this.fieldToString(columnPropertyField));
                break;
            }
            case 5: {
                columnBuilder.label(this.fieldToString(columnPropertyField));
                break;
            }
            case 6: {
                columnBuilder.type(this.fieldToString(columnPropertyField));
                break;
            }
            case 7: {
                columnBuilder.precision(Integer.valueOf(Math.toIntExact(columnPropertyField.value())));
                break;
            }
            case 8: {
                columnBuilder.scale(Integer.valueOf(Math.toIntExact(columnPropertyField.value())));
                break;
            }
            case 9: {
                long v = columnPropertyField.value();
                if (v == 1L) {
                    columnBuilder.nullable(ColumnNullable.NOT_NULL);
                    break;
                }
                if (v == 2L) {
                    columnBuilder.nullable(ColumnNullable.NULLABLE);
                    break;
                }
                columnBuilder.nullable(ColumnNullable.UNKNOWN);
                break;
            }
            case 10: {
                columnBuilder.caseSensitive(Boolean.valueOf(columnPropertyField.value() == 1L));
            }
        }
    }

    private String fieldToString(Field field) {
        return new String(field.contents(), StandardCharsets.UTF_8);
    }

    private List<Field> parseFields(ByteBuffer metadataBuffer) throws ParseException {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (metadataBuffer.hasRemaining()) {
            fields.add(this.readField(metadataBuffer));
        }
        return fields;
    }

    private Field readField(ByteBuffer buffer) throws ParseException {
        try {
            int x = Byte.toUnsignedInt(buffer.get());
            int fieldNumber = x >> 3;
            int fieldType = x & 7;
            switch (fieldType) {
                case 0: {
                    long value = this.readVarint(buffer);
                    return new Field(fieldNumber, fieldType, value, null);
                }
                case 2: {
                    byte[] contents = this.readLengthDelimited(buffer);
                    return new Field(fieldNumber, fieldType, -1L, contents);
                }
            }
            throw new ParseException(String.format("Could not parse metadata: unsupported field type %d", fieldType), buffer.position() - 1);
        }
        catch (BufferUnderflowException e) {
            throw new ParseException("Could not parse metadata: unexpected end of buffer", buffer.limit());
        }
    }

    private byte[] readLengthDelimited(ByteBuffer buffer) {
        int size = Math.toIntExact(this.readVarint(buffer));
        byte[] contents = new byte[size];
        buffer.get(contents);
        return contents;
    }

    private long readVarint(ByteBuffer buffer) {
        int b = Byte.toUnsignedInt(buffer.get());
        int n = b & 0x7F;
        int i = 1;
        while ((b & 0x80) != 0) {
            b = Byte.toUnsignedInt(buffer.get());
            n |= (b & 0x7F) << i * 7;
            ++i;
        }
        return n;
    }

    private static class Field {
        private final int fieldNumber;
        private final int fieldType;
        private final long value;
        private final byte[] contents;

        @Generated
        public Field(int fieldNumber, int fieldType, long value, byte[] contents) {
            this.fieldNumber = fieldNumber;
            this.fieldType = fieldType;
            this.value = value;
            this.contents = contents;
        }

        @Generated
        public int fieldNumber() {
            return this.fieldNumber;
        }

        @Generated
        public int fieldType() {
            return this.fieldType;
        }

        @Generated
        public long value() {
            return this.value;
        }

        @Generated
        public byte[] contents() {
            return this.contents;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.fieldNumber() != other.fieldNumber()) {
                return false;
            }
            if (this.fieldType() != other.fieldType()) {
                return false;
            }
            if (this.value() != other.value()) {
                return false;
            }
            return Arrays.equals(this.contents(), other.contents());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Field;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.fieldNumber();
            result = result * 59 + this.fieldType();
            long $value = this.value();
            result = result * 59 + (int)($value >>> 32 ^ $value);
            result = result * 59 + Arrays.hashCode(this.contents());
            return result;
        }

        @Generated
        public String toString() {
            return "AthenaMetadataParser.Field(fieldNumber=" + this.fieldNumber() + ", fieldType=" + this.fieldType() + ", value=" + this.value() + ", contents=" + Arrays.toString(this.contents()) + ")";
        }
    }
}

