/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.results.GetQueryResultsQueryResultsBase;
import com.amazon.athena.client.results.ResultPage;
import com.amazon.athena.client.results.parsing.GetQueryResultsParser;
import com.amazon.athena.logging.AthenaLogger;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.QueryExecution;

class GetQueryResultsQueryResults
extends GetQueryResultsQueryResultsBase {
    private static final AthenaLogger logger = AthenaLogger.of(GetQueryResultsQueryResults.class);
    private final AthenaAsyncClient athenaClient;
    private final GetQueryResultsParser resultParser;

    GetQueryResultsQueryResults(AthenaAsyncClient athenaClient, Executor executor, QueryExecution queryExecution, ResultPage firstPage, GetQueryResultsParser resultParser) {
        super(executor, queryExecution, firstPage);
        this.athenaClient = athenaClient;
        this.resultParser = resultParser;
    }

    @Override
    protected CompletionStage<ResultPage> loadNextPage(String nextToken) {
        logger.debug("Query execution {} loading the next page", this.queryExecution().queryExecutionId());
        GetQueryResultsRequest request = (GetQueryResultsRequest)GetQueryResultsRequest.builder().queryExecutionId(this.queryExecution().queryExecutionId()).nextToken(nextToken).build();
        return this.athenaClient.getQueryResults(request).thenApply(response -> ResultPage.of(response, this.resultParser));
    }
}

