/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.error.QueryResultException;
import com.amazon.athena.client.results.PaginatingAsyncQueryResultsBase;
import com.amazon.athena.client.results.ResultPage;
import com.amazon.athena.logging.AthenaLogger;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import software.amazon.awssdk.services.athena.model.QueryExecution;

abstract class GetQueryResultsQueryResultsBase
extends PaginatingAsyncQueryResultsBase {
    private static final AthenaLogger logger = AthenaLogger.of(GetQueryResultsQueryResultsBase.class);
    private final String firstNextToken;

    GetQueryResultsQueryResultsBase(Executor executor, QueryExecution queryExecution, ResultPage firstPage) {
        super(executor, queryExecution, firstPage.resultSetMetadata(), firstPage.updateCount(), firstPage.rows());
        this.firstNextToken = firstPage.nextToken();
    }

    protected abstract CompletionStage<ResultPage> loadNextPage(String var1);

    @Override
    protected PaginatingAsyncQueryResultsBase.PaginationController startPagination() {
        return new GetQueryResultsPaginationControl(this.firstNextToken);
    }

    private class GetQueryResultsPaginationControl
    implements PaginatingAsyncQueryResultsBase.PaginationController {
        private String nextToken;

        private GetQueryResultsPaginationControl(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public boolean hasNextPage() {
            return this.nextToken != null;
        }

        @Override
        public void loadNextPage(Consumer<String[]> addRows, Consumer<Throwable> reportError, Runnable done) {
            GetQueryResultsQueryResultsBase.this.loadNextPage(this.nextToken).whenComplete((response, e) -> {
                try {
                    if (e == null) {
                        this.nextToken = response.nextToken();
                        logger.info("Query execution {} loaded a page, got {} rows, {} more pages", GetQueryResultsQueryResultsBase.this.queryExecution().queryExecutionId(), response.rows().size(), this.nextToken == null ? "no" : "has");
                        if (this.nextToken != null) {
                            logger.trace("Query execution {} loaded a page, next token is \"{}\"", GetQueryResultsQueryResultsBase.this.queryExecution().queryExecutionId(), this.nextToken);
                        }
                        response.rows().forEach(addRows);
                    } else {
                        Throwable ee = e instanceof CompletionException ? e.getCause() : e;
                        logger.warn(String.format("Query execution %s failed loading result page: %s", GetQueryResultsQueryResultsBase.this.queryExecution().queryExecutionId(), ee.getMessage()), ee);
                        reportError.accept(new QueryResultException(GetQueryResultsQueryResultsBase.this.queryExecution(), String.format("Could not load query results: %s", ee.getMessage()), ee));
                    }
                }
                catch (RuntimeException re) {
                    logger.warn("Query execution {} failed processing result page: {}", GetQueryResultsQueryResultsBase.this.queryExecution().queryExecutionId(), re.getMessage());
                    reportError.accept(new QueryResultException(GetQueryResultsQueryResultsBase.this.queryExecution(), String.format("Could not process query results: %s", re.getMessage()), re));
                }
                finally {
                    done.run();
                }
            });
        }
    }
}

