/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results.parsing.metadata;

import com.amazon.athena.client.results.parsing.metadata.MetadataFetcher;
import com.amazon.athena.client.results.parsing.metadata.S3StaticMetadataFetcher;
import com.amazon.athena.logging.AthenaLogger;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.QueryExecution;

public class S3GetQueryResultsMetadataFetcher
implements MetadataFetcher {
    private static final AthenaLogger logger = AthenaLogger.of(S3StaticMetadataFetcher.class);
    private final AthenaAsyncClient athenaClient;
    private final QueryExecution queryMetadata;

    public S3GetQueryResultsMetadataFetcher(AthenaAsyncClient athenaClient, QueryExecution queryMetadata) {
        this.athenaClient = athenaClient;
        this.queryMetadata = queryMetadata;
    }

    @Override
    public CompletableFuture<GetQueryResultsResponse> fetchMetadata() {
        logger.debug("Query execution {} loading query result metadata using GetQueryResults", this.queryMetadata.queryExecutionId());
        GetQueryResultsRequest request = (GetQueryResultsRequest)GetQueryResultsRequest.builder().queryExecutionId(this.queryMetadata.queryExecutionId()).maxResults(Integer.valueOf(1)).build();
        return this.athenaClient.getQueryResults(request);
    }
}

