/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;

public class ProfileCredentialsProviderFactory
implements CredentialsProviderFactory {
    public static final ConnectionParameter<String> PROFILE_NAME_PARAMETER = ConnectionParameter.builder().name("ProfileName").build();
    private final ProfileCredentialsProvider.Builder credentialsProviderBuilder;

    public ProfileCredentialsProviderFactory() {
        this(ProfileCredentialsProvider.builder());
    }

    ProfileCredentialsProviderFactory(ProfileCredentialsProvider.Builder credentialsProviderBuilder) {
        this.credentialsProviderBuilder = credentialsProviderBuilder;
    }

    @Override
    public String name() {
        return "ProfileCredentials";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        Optional<String> profileName = PROFILE_NAME_PARAMETER.findValue(parameters);
        Optional<String[]> credentialsProviderArguments = ConnectionParameters.CREDENTIALS_PROVIDER_ARGUMENTS_PARAMETER.findValue(parameters);
        if (profileName.isPresent() && credentialsProviderArguments.isPresent()) {
            throw new IllegalArgumentException(String.format("A profile name cannot be specified both with the \"%s\" parameter and with the \"%s\" parameter", PROFILE_NAME_PARAMETER.name(), ConnectionParameters.CREDENTIALS_PROVIDER_ARGUMENTS_PARAMETER.name()));
        }
        if (profileName.isPresent()) {
            return this.credentialsProviderBuilder.profileName(profileName.get()).build();
        }
        if (credentialsProviderArguments.isPresent()) {
            return this.credentialsProviderBuilder.profileName(credentialsProviderArguments.get()[0]).build();
        }
        return this.credentialsProviderBuilder.build();
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.CREDENTIALS_PROVIDER_ARGUMENTS_PARAMETER, PROFILE_NAME_PARAMETER);
    }
}

