/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.datazone.helpers;

import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class BrowserControlHelper {
    private static final AthenaLogger logger = AthenaLogger.of(BrowserControlHelper.class);
    private final String osName;

    public BrowserControlHelper(String osName) {
        this.osName = osName.toLowerCase();
    }

    public void launchBrowser(URI requestUri) throws IOException, URISyntaxException {
        logger.info(String.format("Open URI: %s", requestUri.toString()), new Object[0]);
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(requestUri);
        } else if (this.osName.contains("win")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + requestUri.toString());
        } else if (this.osName.contains("mac")) {
            Runtime.getRuntime().exec("open " + requestUri.toString());
        } else if (this.osName.contains("nix") || this.osName.contains("nux")) {
            Runtime.getRuntime().exec("xdg-open " + requestUri.toString());
        } else {
            throw new AuthenticationException("Cannot launch Web Browser, Desktop Environment not supported");
        }
    }
}

