/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.datazone.helpers;

import com.amazon.athena.logging.AthenaLogger;
import java.util.ArrayList;
import software.amazon.awssdk.services.ssooidc.SsoOidcClient;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse;
import software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest;
import software.amazon.awssdk.services.ssooidc.model.RegisterClientResponse;

public class SsoOidcHelper {
    private static final AthenaLogger logger = AthenaLogger.of(SsoOidcHelper.class);
    private final SsoOidcClient ssoOidcClient;
    private final int serverListenPort;
    private final String datazoneScope;
    private static final String CLIENT_NAME = "DataZoneAuthPlugin";
    private static final String CLIENT_TYPE = "public";
    private static final String REDIRECT_URI = "http://127.0.0.1:";

    public SsoOidcHelper(SsoOidcClient ssoOidcClient, int serverListenPort, String datazoneScope) {
        this.ssoOidcClient = ssoOidcClient;
        this.serverListenPort = serverListenPort;
        this.datazoneScope = datazoneScope;
    }

    public RegisterClientResponse registerClient(String issuerUrl) {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(this.datazoneScope);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("authorization_code");
        ArrayList<String> redirectUris = new ArrayList<String>();
        redirectUris.add(REDIRECT_URI + this.serverListenPort);
        RegisterClientRequest registerClientRequest = (RegisterClientRequest)RegisterClientRequest.builder().clientName(CLIENT_NAME).clientType(CLIENT_TYPE).issuerUrl(issuerUrl).scopes(scopes).grantTypes(grantTypes).redirectUris(redirectUris).build();
        logger.trace(String.format("Registering Client with IAM Identity Center with name: %s, scopes: %s", CLIENT_NAME, scopes), new Object[0]);
        RegisterClientResponse registerClientResponse = this.ssoOidcClient.registerClient(registerClientRequest);
        logger.info("Successfully registered client with iam identity center", new Object[0]);
        return registerClientResponse;
    }

    public String retrieveAccessToken(RegisterClientResponse registeredClient, String codeVerifier, String authCode) {
        CreateTokenRequest createTokenRequest = (CreateTokenRequest)CreateTokenRequest.builder().clientId(registeredClient.clientId()).clientSecret(registeredClient.clientSecret()).grantType("authorization_code").redirectUri(REDIRECT_URI + this.serverListenPort).codeVerifier(codeVerifier).code(authCode).build();
        logger.trace("Retrieving access token from iam identity center...", new Object[0]);
        CreateTokenResponse createTokenResponse = this.ssoOidcClient.createToken(createTokenRequest);
        logger.info("Successfully retrieved access token from iam identity center", new Object[0]);
        return createTokenResponse.accessToken();
    }
}

