/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.datazone.httpserver;

import com.amazon.athena.jdbc.authentication.datazone.httpserver.InvalidHttpRequestHandler;
import com.amazon.athena.jdbc.authentication.datazone.httpserver.RequestHandler;
import com.amazon.athena.jdbc.authentication.datazone.httpserver.ValidHttpRequestHandler;
import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.net.ServerSocketFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.NameValuePair;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnectionFactory;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.slf4j.Logger;
import software.amazon.awssdk.utils.IoUtils;

public class Server {
    private static final AthenaLogger logger = AthenaLogger.of(Server.class);
    private final DefaultBHttpServerConnectionFactory connectionFactory;
    private final InetAddress ipAddress;
    private final int listenPort;
    private int localPort = 0;
    private final ServerSocketFactory serverSocketFactory;
    private final ExecutorService executorService;

    public Server(int listenPort) {
        this(null, null, listenPort);
    }

    Server(ServerSocketFactory serverSocketFactory, DefaultBHttpServerConnectionFactory connectionFactory, int listenPort) {
        logger.info("Server requested to listen on port {}", listenPort);
        this.serverSocketFactory = this.getServerSocketFactory(serverSocketFactory);
        this.listenPort = listenPort;
        this.connectionFactory = this.getConnectionFactory(connectionFactory);
        this.ipAddress = InetAddress.getLoopbackAddress();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void shutdownServer() {
        this.executorService.shutdown();
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public Future<List<NameValuePair>> listenForResponse() {
        ServerSocket serverSocket = this.getServerSocket();
        RequestHandler requestHandler = this.getRequestHandler();
        HttpService httpService = this.getHttpService(requestHandler);
        this.localPort = serverSocket.getLocalPort();
        CountDownLatch startSignal = new CountDownLatch(1);
        Future<List<NameValuePair>> future = this.executorService.submit(new GetHttpResponseTask(serverSocket, this.connectionFactory, httpService, requestHandler, startSignal));
        try {
            startSignal.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new AuthenticationException("The thread got interrupted while preparing to listen.", ex);
        }
        logger.trace("Server started listening for a connection.", new Object[0]);
        return future;
    }

    private HttpService getHttpService(RequestHandler requestHandler) {
        return new HttpService(HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).build(), (HttpRequestHandlerMapper)this.prepareRequestMapper(requestHandler));
    }

    private DefaultBHttpServerConnectionFactory getConnectionFactory(DefaultBHttpServerConnectionFactory connectionFactory) {
        return connectionFactory == null ? DefaultBHttpServerConnectionFactory.INSTANCE : connectionFactory;
    }

    private ServerSocketFactory getServerSocketFactory(ServerSocketFactory socketFactory) {
        return socketFactory == null ? ServerSocketFactory.getDefault() : socketFactory;
    }

    private RequestHandler getRequestHandler() {
        return new RequestHandler(Function.identity(), new ValidHttpRequestHandler(), new InvalidHttpRequestHandler());
    }

    private ServerSocket getServerSocket() {
        ServerSocket socket = null;
        try {
            socket = this.serverSocketFactory.createServerSocket(this.listenPort, 10, this.ipAddress);
        }
        catch (IOException ex) {
            logger.trace("Couldn't create a server socket {}", ex.getMessage());
            throw new AuthenticationException("Couldn't create a server socket.", ex);
        }
        try {
            socket.setSoTimeout(1000);
        }
        catch (SocketException ex) {
            logger.trace("Couldn't set socket timeout {}", ex.getMessage());
            IoUtils.closeQuietly((AutoCloseable)socket, (Logger)logger.wrappedLogger());
            throw new AuthenticationException("Couldn't set socket timeout.", ex);
        }
        return socket;
    }

    private UriHttpRequestHandlerMapper prepareRequestMapper(HttpRequestHandler handler) {
        UriHttpRequestHandlerMapper mapper = new UriHttpRequestHandlerMapper();
        mapper.register("*", handler);
        return mapper;
    }

    class GetHttpResponseTask
    implements Callable<List<NameValuePair>> {
        private final ServerSocket serverSocket;
        private final HttpService httpService;
        private final DefaultBHttpServerConnectionFactory connectionFactory;
        private final RequestHandler requestHandler;
        private final CountDownLatch latch;

        public GetHttpResponseTask(ServerSocket serverSocket, DefaultBHttpServerConnectionFactory connectionFactory, HttpService httpService, RequestHandler requestHandler, CountDownLatch latch) {
            this.serverSocket = serverSocket;
            this.httpService = httpService;
            this.connectionFactory = connectionFactory;
            this.requestHandler = requestHandler;
            this.latch = latch;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<NameValuePair> call() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        this.latch.countDown();
                        Socket socket = this.serverSocket.accept();
                        logger.trace("Client is connected: " + socket, new Object[0]);
                        socket.setKeepAlive(false);
                        socket.setSoTimeout(1000);
                        try (DefaultBHttpServerConnection conn = this.connectionFactory.createConnection(socket);){
                            BasicHttpContext localContext = new BasicHttpContext();
                            HttpCoreContext context = HttpCoreContext.adapt((HttpContext)localContext);
                            this.httpService.handleRequest((HttpServerConnection)conn, (HttpContext)context);
                        }
                        catch (HttpException ex) {
                            logger.debug("Error happened during HTTP communication.", ex);
                            throw new AuthenticationException(ex.getMessage(), ex);
                        }
                        List<NameValuePair> list = this.requestHandler.getResult();
                        return list;
                    }
                    catch (SocketTimeoutException ex) {
                        logger.trace("Timed out, continue waiting for a connection.", new Object[0]);
                    }
                }
                logger.trace("Listening thread got interrupted.", new Object[0]);
                List<NameValuePair> ex = null;
                return ex;
            }
            catch (IOException ex) {
                logger.debug("IO Exception happened on connection.", ex);
                throw new AuthenticationException(ex.getMessage(), ex);
            }
            catch (Exception ex) {
                logger.debug("Received an exception", ex);
                throw new AuthenticationException("Exception happened.", ex);
            }
            finally {
                logger.trace("Closing server socket and connection.", new Object[0]);
                IoUtils.closeQuietly((AutoCloseable)this.serverSocket, (Logger)logger.wrappedLogger());
            }
        }
    }
}

