/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.utils;

import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.utils.StringUtils;

public class AzureAdAuthUtils {
    private static final AthenaLogger logger = AthenaLogger.of(AzureAdAuthUtils.class);

    public static String wrapAndEncodeAssertion(String samlAssertion) {
        String samlAssertionString = "<samlp:Response xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"><samlp:Status><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/></samlp:Status>" + samlAssertion + "</samlp:Response>";
        return org.apache.commons.codec.binary.StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])samlAssertionString.getBytes()));
    }

    public static String extractAzureAdSamlAssertion(String content) {
        JsonNode entityJson = JsonNodeParser.create().parse(content);
        JsonNode accessTokenField = (JsonNode)entityJson.field("access_token").orElseThrow(() -> new AuthenticationException("Failed to find access_token in response from Azure AD"));
        String encodedSamlAssertion = accessTokenField.text();
        if (StringUtils.isEmpty((CharSequence)encodedSamlAssertion)) {
            throw new AuthenticationException("Empty access_token in the response from Azure AD");
        }
        return new String(Base64.decodeBase64((String)encodedSamlAssertion), Charset.forName("UTF-8"));
    }

    public static void throwOnBadAzureAdSamlResponse(String content) {
        JsonNode entityJson = JsonNodeParser.create().parse(content);
        String description = entityJson.field("error_description").map(JsonNode::text).orElse("");
        if (!StringUtils.isEmpty((CharSequence)description)) {
            description = description.replaceAll("\r\n", " ");
            String errorName = entityJson.field("error").map(JsonNode::text).orElse("");
            String message = String.format("AzureAD responded with error. Error: %s, Description: %s", errorName, description);
            throw new AuthenticationException(message);
        }
        logger.warn("Unexpected response from AzureAD.", content);
        throw new AuthenticationException("Failed to get SAML assertion from Azure AD.");
    }
}

