/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.cache;

import com.amazon.athena.jdbc.cache.CacheEntry;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;

public class TokenCacheEntry
implements CacheEntry {
    private final String idToken;
    private final String refreshToken;
    private final String stsIdentityContext;
    private final Instant expiration;

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isExpired(Duration threshold) {
        return Instant.now().plus(threshold).isAfter(this.getExpiration());
    }

    @Generated
    TokenCacheEntry(String idToken, String refreshToken, String stsIdentityContext, Instant expiration) {
        this.idToken = idToken;
        this.refreshToken = refreshToken;
        this.stsIdentityContext = stsIdentityContext;
        this.expiration = expiration;
    }

    @Generated
    public static TokenCacheEntryBuilder builder() {
        return new TokenCacheEntryBuilder();
    }

    @Generated
    public String getIdToken() {
        return this.idToken;
    }

    @Generated
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Generated
    public String getStsIdentityContext() {
        return this.stsIdentityContext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenCacheEntry)) {
            return false;
        }
        TokenCacheEntry other = (TokenCacheEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$idToken = this.getIdToken();
        String other$idToken = other.getIdToken();
        if (this$idToken == null ? other$idToken != null : !this$idToken.equals(other$idToken)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$stsIdentityContext = this.getStsIdentityContext();
        String other$stsIdentityContext = other.getStsIdentityContext();
        if (this$stsIdentityContext == null ? other$stsIdentityContext != null : !this$stsIdentityContext.equals(other$stsIdentityContext)) {
            return false;
        }
        Instant this$expiration = this.getExpiration();
        Instant other$expiration = other.getExpiration();
        return !(this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TokenCacheEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $idToken = this.getIdToken();
        result = result * 59 + ($idToken == null ? 43 : $idToken.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $stsIdentityContext = this.getStsIdentityContext();
        result = result * 59 + ($stsIdentityContext == null ? 43 : $stsIdentityContext.hashCode());
        Instant $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TokenCacheEntry(idToken=" + this.getIdToken() + ", refreshToken=" + this.getRefreshToken() + ", stsIdentityContext=" + this.getStsIdentityContext() + ", expiration=" + this.getExpiration() + ")";
    }

    @Generated
    public static class TokenCacheEntryBuilder {
        @Generated
        private String idToken;
        @Generated
        private String refreshToken;
        @Generated
        private String stsIdentityContext;
        @Generated
        private Instant expiration;

        @Generated
        TokenCacheEntryBuilder() {
        }

        @Generated
        public TokenCacheEntryBuilder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        @Generated
        public TokenCacheEntryBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Generated
        public TokenCacheEntryBuilder stsIdentityContext(String stsIdentityContext) {
            this.stsIdentityContext = stsIdentityContext;
            return this;
        }

        @Generated
        public TokenCacheEntryBuilder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        @Generated
        public TokenCacheEntry build() {
            return new TokenCacheEntry(this.idToken, this.refreshToken, this.stsIdentityContext, this.expiration);
        }

        @Generated
        public String toString() {
            return "TokenCacheEntry.TokenCacheEntryBuilder(idToken=" + this.idToken + ", refreshToken=" + this.refreshToken + ", stsIdentityContext=" + this.stsIdentityContext + ", expiration=" + this.expiration + ")";
        }
    }
}

