/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.results;

import com.amazon.athena.jdbc.AthenaDataType;
import com.amazon.athena.jdbc.configuration.ConnectionConfiguration;
import com.amazon.athena.jdbc.results.IteratorResultSetBase;
import com.amazon.athena.jdbc.support.PaginatingIteratorBase;
import com.amazon.athena.logging.AthenaLogger;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.model.DataCatalogSummary;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.utils.Pair;

public class ListDataCatalogsResultSet
extends IteratorResultSetBase<DataCatalogSummary> {
    private static final AthenaLogger logger = AthenaLogger.of(ListDataCatalogsResultSet.class);
    private static final String CATALOGS_TABLE_NAME = "CATALOGS";
    private static final String CATALOG_COLUMN_NAME = "TABLE_CAT";
    private static final ResultSetMetadata META_DATA = (ResultSetMetadata)ResultSetMetadata.builder().columnInfo(new ColumnInfo[]{(ColumnInfo)ColumnInfo.builder().label("TABLE_CAT").name("TABLE_CAT").type(AthenaDataType.VARCHAR.athenaName()).tableName("CATALOGS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(256)).scale(Integer.valueOf(0)).caseSensitive(Boolean.valueOf(false)).nullable(ColumnNullable.NOT_NULL).build()}).build();
    private final ConnectionConfiguration configuration;

    public ListDataCatalogsResultSet(ConnectionConfiguration configuration) {
        super(META_DATA);
        this.configuration = configuration;
    }

    @Override
    protected Iterator<DataCatalogSummary> iterator() {
        return new DataCatalogsIterator(this.configuration.getAthenaSdkClient(), this.configuration.getApiRequestTimeout(), this.configuration.getWorkGroup());
    }

    @Override
    protected String stringValue(DataCatalogSummary row, int columnIndex) {
        return row.catalogName();
    }

    private static class DataCatalogsIterator
    extends PaginatingIteratorBase<DataCatalogSummary> {
        private final AthenaAsyncClient athenaClient;
        private final String workGroup;

        DataCatalogsIterator(AthenaAsyncClient athenaClient, Duration requestTimeout, String workGroup) {
            super(requestTimeout);
            this.athenaClient = athenaClient;
            this.workGroup = workGroup;
        }

        @Override
        protected CompletableFuture<Pair<List<DataCatalogSummary>, Optional<String>>> loadNextPage(Optional<String> nextToken) {
            ListDataCatalogsRequest request = (ListDataCatalogsRequest)ListDataCatalogsRequest.builder().workGroup(this.workGroup).nextToken((String)nextToken.orElse(null)).build();
            logger.debug("Listing catalogs", new Object[0]);
            logger.trace("Sending ListDataCatalogs request: {}", request);
            return ((CompletableFuture)this.athenaClient.listDataCatalogs(request).whenComplete((response, error) -> {
                if (error != null) {
                    logger.warn(String.format("Could not list catalogs: %s", error.getMessage()), (Throwable)error);
                }
            })).thenApply(response -> {
                logger.info("Listing catalogs succeeded, got {} catalog(s)", response.dataCatalogsSummary().size());
                return Pair.of((Object)response.dataCatalogsSummary(), Optional.ofNullable(response.nextToken()));
            });
        }
    }
}

