/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class ConvertFunction
extends JdbcFunction {
    private static final Map<String, String> TYPE_CONVERSIONS = new HashMap<String, String>(){
        {
            this.put("SQL_BIGINT", "BIGINT");
            this.put("SQL_BOOLEAN", "BOOLEAN");
            this.put("SQL_CHAR", "CHAR");
            this.put("SQL_DATE", "DATE");
            this.put("SQL_DECIMAL", "DECIMAL");
            this.put("SQL_DOUBLE", "DOUBLE");
            this.put("SQL_FLOAT", "REAL");
            this.put("SQL_INTEGER", "INTEGER");
            this.put("SQL_SMALLINT", "SMALLINT");
            this.put("SQL_TIME", "TIME");
            this.put("SQL_TIMESTAMP", "TIMESTAMP");
            this.put("SQL_TINYINT", "TINYINT");
            this.put("SQL_VARBINARY", "VARBINARY");
            this.put("SQL_VARCHAR", "VARCHAR");
            this.put("BIGINT", "BIGINT");
            this.put("BOOLEAN", "BOOLEAN");
            this.put("CHAR", "CHAR");
            this.put("DATE", "DATE");
            this.put("DECIMAL", "DECIMAL");
            this.put("DOUBLE", "DOUBLE");
            this.put("FLOAT", "REAL");
            this.put("INTEGER", "INTEGER");
            this.put("SMALLINT", "SMALLINT");
            this.put("TIME", "TIME");
            this.put("TIMESTAMP", "TIMESTAMP");
            this.put("TINYINT", "TINYINT");
            this.put("VARBINARY", "VARBINARY");
            this.put("VARCHAR", "VARCHAR");
        }
    };

    ConvertFunction() {
        super("CONVERT", "CAST", JdbcFunction.FunctionCategory.CONVERSION, 2, 2);
    }

    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> args = super.processArguments(rawArgs);
        Optional<Token> typeExpr = this.findFirstExpression(args.get(1));
        Optional<String> type = typeExpr.map(t -> TYPE_CONVERSIONS.get(t.value().toUpperCase()));
        if (type.isPresent()) {
            List<Token> oldArg = this.ensureHasWhitespacePrefix(new LinkedList<Token>((Collection)args.get(1)));
            oldArg.replaceAll(t -> t == typeExpr.get() ? Token.sql((String)type.get()) : t);
            LinkedList<Token> newArg = new LinkedList<Token>((Collection)args.get(0));
            newArg.add(Token.space());
            newArg.add(Token.sql("AS"));
            newArg.addAll(oldArg);
            return Collections.singletonList(newArg);
        }
        String unsupportedType = typeExpr.map(Token::value).orElse("");
        String message = String.format("Unsupported type for the CONVERT function, got \"%s\"", unsupportedType);
        throw new FunctionExpressionException(message);
    }
}

