/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.core;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingKnownType;
import software.amazon.awssdk.core.protocol.MarshallingType;

@SdkProtectedApi
public abstract class AbstractMarshallingRegistry {
    private final MarshallingLocationRegistry locationRegistry;
    private final Set<MarshallingType<?>> marshallingTypes;
    private final Map<Class<?>, MarshallingType<?>> marshallingTypeCache;

    protected AbstractMarshallingRegistry(Builder builder) {
        this.locationRegistry = builder.locationRegistry.build();
        this.marshallingTypes = builder.marshallingTypes;
        this.marshallingTypeCache = new HashMap(this.marshallingTypes.size());
    }

    protected Object get(MarshallLocation marshallLocation, MarshallingType<?> marshallingType) {
        return this.locationRegistry.get(marshallLocation, marshallingType);
    }

    protected <T> MarshallingType<T> toMarshallingType(T val) {
        if (val == null) {
            return MarshallingType.NULL;
        }
        if (val instanceof SdkPojo) {
            return MarshallingType.SDK_POJO;
        }
        if (!this.marshallingTypeCache.containsKey(val.getClass())) {
            return this.populateMarshallingTypeCache(val.getClass());
        }
        return this.marshallingTypeCache.get(val.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshallingType<?> populateMarshallingTypeCache(Class<?> clzz) {
        Map<Class<?>, MarshallingType<?>> map = this.marshallingTypeCache;
        synchronized (map) {
            if (!this.marshallingTypeCache.containsKey(clzz)) {
                for (MarshallingType<?> marshallingType : this.marshallingTypes) {
                    if (!marshallingType.getTargetClass().isAssignableFrom(clzz)) continue;
                    this.marshallingTypeCache.put(clzz, marshallingType);
                    return marshallingType;
                }
                throw SdkClientException.builder().message("MarshallingType not found for class " + clzz).build();
            }
        }
        return this.marshallingTypeCache.get(clzz);
    }

    static class MarshallingLocationRegistry {
        private final Map<MarshallLocation, MarshallingTypeRegistry> registry = new EnumMap<MarshallLocation, MarshallingTypeRegistry>(MarshallLocation.class);

        private MarshallingLocationRegistry(Builder builder) {
            builder.registry.forEach((k, v) -> this.registry.put((MarshallLocation)k, v.build()));
        }

        public Object get(MarshallLocation location, MarshallingType<?> marshallingType) {
            MarshallingTypeRegistry byLocation = this.registry.get(location);
            if (byLocation != null) {
                return byLocation.get(marshallingType);
            }
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        static class Builder {
            private Map<MarshallLocation, MarshallingTypeRegistry.Builder> registry = new EnumMap<MarshallLocation, MarshallingTypeRegistry.Builder>(MarshallLocation.class);

            private Builder() {
            }

            private Builder(MarshallingLocationRegistry marshallingLocationRegistry) {
                marshallingLocationRegistry.registry.forEach((k, v) -> this.registry.put((MarshallLocation)k, v.toBuilder()));
            }

            public <T> Builder register(MarshallLocation location, MarshallingType<T> marshallingType, Object marshaller) {
                this.registry.computeIfAbsent(location, x -> MarshallingTypeRegistry.builder()).register(marshallingType, marshaller);
                return this;
            }

            public MarshallingLocationRegistry build() {
                return new MarshallingLocationRegistry(this);
            }
        }
    }

    public static abstract class Builder {
        private final MarshallingLocationRegistry.Builder locationRegistry;
        private final Set<MarshallingType<?>> marshallingTypes = new HashSet();

        protected Builder() {
            this.locationRegistry = MarshallingLocationRegistry.builder();
        }

        protected Builder(AbstractMarshallingRegistry marshallingRegistry) {
            this.locationRegistry = marshallingRegistry.locationRegistry.toBuilder();
            this.marshallingTypes.addAll(marshallingRegistry.marshallingTypes);
        }

        protected <T> Builder register(MarshallLocation marshallLocation, MarshallingType<T> marshallingType, Object marshaller) {
            this.marshallingTypes.add(marshallingType);
            this.locationRegistry.register(marshallLocation, marshallingType, marshaller);
            return this;
        }
    }

    static class MarshallingTypeRegistry {
        private final Map<MarshallingKnownType, Object> l1registry;
        private final Map<MarshallingType<?>, Object> l2registry;

        private MarshallingTypeRegistry(Builder builder) {
            this.l1registry = new EnumMap<MarshallingKnownType, Object>(builder.l1registry);
            this.l2registry = builder.l2registry;
        }

        public Object get(MarshallingType<?> marshallingType) {
            MarshallingKnownType knownType = marshallingType.getKnownType();
            if (knownType != null) {
                return this.l1registry.get(knownType);
            }
            return this.l2registry.get(marshallingType);
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        static class Builder {
            private Map<MarshallingKnownType, Object> l1registry = new EnumMap<MarshallingKnownType, Object>(MarshallingKnownType.class);
            private Map<MarshallingType<?>, Object> l2registry = new HashMap();

            private Builder() {
            }

            private Builder(MarshallingTypeRegistry marshallingTypeRegistry) {
                this.l1registry.putAll(marshallingTypeRegistry.l1registry);
                this.l2registry.putAll(marshallingTypeRegistry.l2registry);
            }

            public <T> Builder register(MarshallingType<T> marshallingType, Object marshaller) {
                MarshallingKnownType knownType = marshallingType.getKnownType();
                if (knownType != null) {
                    this.l1registry.put(knownType, marshaller);
                } else {
                    this.l2registry.put(marshallingType, marshaller);
                }
                return this;
            }

            public MarshallingTypeRegistry build() {
                return new MarshallingTypeRegistry(this);
            }
        }
    }
}

