/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client;

import com.amazon.athena.client.AsyncQueryExecution;
import com.amazon.athena.client.error.QueryExecutionException;
import com.amazon.athena.client.error.QueryExecutionTimedOutException;
import com.amazon.athena.client.polling.BackoffPollingStrategy;
import com.amazon.athena.client.polling.PollingStrategy;
import com.amazon.athena.client.results.AsyncQueryResults;
import com.amazon.athena.client.results.AsyncQueryResultsFactory;
import com.amazon.athena.logging.AthenaLogger;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.AthenaAsyncClientBuilder;
import software.amazon.awssdk.services.athena.model.AclConfiguration;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionResponse;
import software.amazon.awssdk.utils.DaemonThreadFactory;

public class AsyncAthena
implements AutoCloseable {
    private static final AthenaLogger logger = AthenaLogger.of(AsyncAthena.class);
    private final AthenaAsyncClient athenaClient;
    private final AsyncQueryResultsFactory queryResultsFactory;
    private final ScheduledExecutorService scheduler;
    private final String catalog;
    private final String database;
    private final String workGroup;
    private final String outputLocation;
    private final EncryptionConfiguration encryptionConfiguration;
    private final String expectedBucketOwner;
    private final AclConfiguration aclConfiguration;
    private final PollingStrategy pollingStrategy;
    private final CloseBehavior closeBehavior;
    private final AtomicBoolean open;
    private final Boolean enableResultReuseByAge;
    private final Integer maxResultReuseAgeInMinutes;
    private final Clock clock;

    private AsyncAthena(AthenaAsyncClient athenaClient, AsyncQueryResultsFactory queryResultsFactory, ScheduledExecutorService scheduler, AwsCredentialsProvider credentialsProvider, Region region, String catalog, String database, String workGroup, String outputLocation, EncryptionConfiguration encryptionConfiguration, String expectedBucketOwner, AclConfiguration aclConfiguration, PollingStrategy pollingStrategy, URI endpoint, Boolean enableResultReuseByAge, Integer maxResultReuseAgeInMinutes, Clock clock) {
        this.athenaClient = athenaClient == null ? (AthenaAsyncClient)((AthenaAsyncClientBuilder)((AthenaAsyncClientBuilder)((AthenaAsyncClientBuilder)AthenaAsyncClient.builder().credentialsProvider(credentialsProvider)).region(region)).endpointOverride(endpoint)).build() : athenaClient;
        this.queryResultsFactory = queryResultsFactory;
        this.scheduler = scheduler == null ? Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory(Executors.defaultThreadFactory())) : scheduler;
        this.catalog = catalog;
        this.database = database;
        this.workGroup = workGroup;
        this.outputLocation = outputLocation;
        this.encryptionConfiguration = encryptionConfiguration;
        this.expectedBucketOwner = expectedBucketOwner;
        this.aclConfiguration = aclConfiguration;
        this.pollingStrategy = pollingStrategy == null ? new BackoffPollingStrategy(2L, Duration.ofMillis(5L), Duration.ofSeconds(5L)) : pollingStrategy;
        this.clock = clock == null ? Clock.systemDefaultZone() : clock;
        this.closeBehavior = new CloseBehavior(athenaClient == null, scheduler == null);
        this.open = new AtomicBoolean(true);
        this.enableResultReuseByAge = enableResultReuseByAge;
        this.maxResultReuseAgeInMinutes = maxResultReuseAgeInMinutes;
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            logger.debug("Closing", new Object[0]);
            if (this.closeBehavior.shutDownScheduler()) {
                this.scheduler.shutdown();
            }
            if (this.closeBehavior.closeAthenaClient()) {
                this.athenaClient.close();
            }
        }
    }

    public AsyncQueryExecution execute(String sql) {
        return this.execute(sql, Collections.emptyList(), ChronoUnit.FOREVER.getDuration());
    }

    public AsyncQueryExecution execute(String sql, List<String> parameters) {
        return this.execute(sql, parameters, ChronoUnit.FOREVER.getDuration());
    }

    public AsyncQueryExecution execute(String sql, List<String> parameters, Duration queryTimeout) {
        this.ensureOpen();
        if (queryTimeout.isNegative()) {
            throw new IllegalArgumentException("Query timeout cannot be negative");
        }
        logger.debug("Starting query execution", new Object[0]);
        StartQueryExecutionRequest request = this.createStartQueryExecutionRequest(sql, parameters);
        logger.trace("Query execution parameters: {}", request);
        CompletableFuture<StartQueryExecutionResponse> pendingResponse = this.athenaClient.startQueryExecution(request);
        Instant queryDeadline = this.calculateTimeoutInstant(queryTimeout);
        CompletionStage pendingQueryExecutionId = ((CompletableFuture)pendingResponse.whenComplete((r, e) -> {
            if (e != null) {
                logger.warn(String.format("Could not start query execution: %s", e.getMessage()), (Throwable)e);
            }
        })).thenApply(StartQueryExecutionResponse::queryExecutionId);
        AsyncQueryExecutionImpl pendingQueryResults = new AsyncQueryExecutionImpl((CompletableFuture<String>)pendingQueryExecutionId);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)pendingQueryExecutionId).thenCompose(queryExecutionId -> this.awaitCompletion((String)queryExecutionId, queryDeadline, queryTimeout))).thenCompose(this.queryResultsFactory::create)).thenApply(pendingQueryResults::complete)).exceptionally(pendingQueryResults::completeExceptionally);
        return pendingQueryResults;
    }

    private void ensureOpen() {
        if (!this.open.get()) {
            throw new IllegalStateException("Client is closed");
        }
    }

    private StartQueryExecutionRequest createStartQueryExecutionRequest(String sql, List<String> parameters) {
        StartQueryExecutionRequest.Builder builder = StartQueryExecutionRequest.builder();
        builder.queryString(sql);
        builder.workGroup(this.workGroup);
        if (this.catalog != null || this.database != null) {
            builder.queryExecutionContext(ctx -> {
                ctx.catalog(this.catalog);
                ctx.database(this.database);
            });
        }
        if (this.outputLocation != null || this.encryptionConfiguration != null || this.expectedBucketOwner != null || this.aclConfiguration != null) {
            builder.resultConfiguration(cfg -> {
                cfg.outputLocation(this.outputLocation);
                cfg.encryptionConfiguration(this.encryptionConfiguration);
                cfg.expectedBucketOwner(this.expectedBucketOwner);
                cfg.aclConfiguration(this.aclConfiguration);
            });
        }
        builder.resultReuseConfiguration(resultReuseCfg -> resultReuseCfg.resultReuseByAgeConfiguration(resultReuseByAgeCfg -> {
            resultReuseByAgeCfg.enabled(this.enableResultReuseByAge);
            resultReuseByAgeCfg.maxAgeInMinutes(this.maxResultReuseAgeInMinutes);
        }));
        if (parameters != null && !parameters.isEmpty()) {
            builder.executionParameters(parameters);
        }
        return (StartQueryExecutionRequest)builder.build();
    }

    private Instant calculateTimeoutInstant(Duration queryTimeout) {
        if (queryTimeout == ChronoUnit.FOREVER.getDuration()) {
            return Instant.MAX;
        }
        return this.clock.instant().plus(queryTimeout);
    }

    private CompletionStage<StopQueryExecutionResponse> stopQueryExecution(String queryExecutionId) {
        this.ensureOpen();
        logger.info("Query execution {} cancelled, stopping query execution", queryExecutionId);
        return this.athenaClient.stopQueryExecution((StopQueryExecutionRequest.Builder builder) -> builder.queryExecutionId(queryExecutionId));
    }

    private CompletionStage<QueryExecution> awaitCompletion(String queryExecutionId, Instant queryDeadline, Duration queryTimeout) {
        logger.info("Query execution {} started", queryExecutionId);
        CompletionPoller poller = new CompletionPoller(queryExecutionId, queryDeadline, queryTimeout);
        return poller.run();
    }

    @Generated
    public static AsyncAthenaBuilder builder() {
        return new AsyncAthenaBuilder();
    }

    @Generated
    public static class AsyncAthenaBuilder {
        @Generated
        private AthenaAsyncClient athenaClient;
        @Generated
        private AsyncQueryResultsFactory queryResultsFactory;
        @Generated
        private ScheduledExecutorService scheduler;
        @Generated
        private AwsCredentialsProvider credentialsProvider;
        @Generated
        private Region region;
        @Generated
        private String catalog;
        @Generated
        private String database;
        @Generated
        private String workGroup;
        @Generated
        private String outputLocation;
        @Generated
        private EncryptionConfiguration encryptionConfiguration;
        @Generated
        private String expectedBucketOwner;
        @Generated
        private AclConfiguration aclConfiguration;
        @Generated
        private PollingStrategy pollingStrategy;
        @Generated
        private URI endpoint;
        @Generated
        private Boolean enableResultReuseByAge;
        @Generated
        private Integer maxResultReuseAgeInMinutes;
        @Generated
        private Clock clock;

        @Generated
        AsyncAthenaBuilder() {
        }

        @Generated
        public AsyncAthenaBuilder athenaClient(AthenaAsyncClient athenaClient) {
            this.athenaClient = athenaClient;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder queryResultsFactory(AsyncQueryResultsFactory queryResultsFactory) {
            this.queryResultsFactory = queryResultsFactory;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder scheduler(ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder region(Region region) {
            this.region = region;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder database(String database) {
            this.database = database;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder aclConfiguration(AclConfiguration aclConfiguration) {
            this.aclConfiguration = aclConfiguration;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder pollingStrategy(PollingStrategy pollingStrategy) {
            this.pollingStrategy = pollingStrategy;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder endpoint(URI endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder enableResultReuseByAge(Boolean enableResultReuseByAge) {
            this.enableResultReuseByAge = enableResultReuseByAge;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder maxResultReuseAgeInMinutes(Integer maxResultReuseAgeInMinutes) {
            this.maxResultReuseAgeInMinutes = maxResultReuseAgeInMinutes;
            return this;
        }

        @Generated
        public AsyncAthenaBuilder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @Generated
        public AsyncAthena build() {
            return new AsyncAthena(this.athenaClient, this.queryResultsFactory, this.scheduler, this.credentialsProvider, this.region, this.catalog, this.database, this.workGroup, this.outputLocation, this.encryptionConfiguration, this.expectedBucketOwner, this.aclConfiguration, this.pollingStrategy, this.endpoint, this.enableResultReuseByAge, this.maxResultReuseAgeInMinutes, this.clock);
        }

        @Generated
        public String toString() {
            return "AsyncAthena.AsyncAthenaBuilder(athenaClient=" + this.athenaClient + ", queryResultsFactory=" + this.queryResultsFactory + ", scheduler=" + this.scheduler + ", credentialsProvider=" + this.credentialsProvider + ", region=" + this.region + ", catalog=" + this.catalog + ", database=" + this.database + ", workGroup=" + this.workGroup + ", outputLocation=" + this.outputLocation + ", encryptionConfiguration=" + this.encryptionConfiguration + ", expectedBucketOwner=" + this.expectedBucketOwner + ", aclConfiguration=" + this.aclConfiguration + ", pollingStrategy=" + this.pollingStrategy + ", endpoint=" + this.endpoint + ", enableResultReuseByAge=" + this.enableResultReuseByAge + ", maxResultReuseAgeInMinutes=" + this.maxResultReuseAgeInMinutes + ", clock=" + this.clock + ")";
        }
    }

    private class CompletionPoller {
        private final String queryExecutionId;
        private final CompletableFuture<QueryExecution> pendingQueryExecution;
        private final Instant queryDeadline;
        private final Duration queryTimeout;
        private Duration nextDelay;
        private QueryExecution lastQueryExecution;

        CompletionPoller(String queryExecutionId, Instant queryDeadline, Duration queryTimeout) {
            this.queryExecutionId = queryExecutionId;
            this.pendingQueryExecution = new CompletableFuture();
            this.nextDelay = AsyncAthena.this.pollingStrategy.nextDelay(Duration.ZERO);
            this.queryDeadline = queryDeadline;
            this.queryTimeout = queryTimeout;
        }

        CompletionStage<QueryExecution> run() {
            this.scheduleNextPoll();
            return this.pendingQueryExecution;
        }

        void scheduleNextPoll() {
            AsyncAthena.this.ensureOpen();
            Instant now = AsyncAthena.this.clock.instant();
            long nextDelayMillis = this.nextDelay.toMillis();
            if (now.plus(this.nextDelay).isAfter(this.queryDeadline)) {
                nextDelayMillis = Math.max(0L, this.queryDeadline.minusMillis(now.toEpochMilli()).toEpochMilli());
            }
            logger.trace("Query execution {} scheduling polling task to run in {} ms", this.queryExecutionId, nextDelayMillis);
            AsyncAthena.this.scheduler.schedule(this::poll, nextDelayMillis, TimeUnit.MILLISECONDS);
        }

        private boolean hasTimedOut() {
            Instant now = AsyncAthena.this.clock.instant();
            return now.equals(this.queryDeadline) || now.isAfter(this.queryDeadline);
        }

        private void handleTimeout() {
            logger.info("Query execution {} timed out after {} ms, stopping query execution", this.queryExecutionId, this.queryTimeout.toMillis());
            AsyncAthena.this.stopQueryExecution(this.queryExecutionId).whenComplete((response, error) -> {
                if (error != null) {
                    logger.warn(String.format("Could not cancel query %s after client side timeout: %s", this.queryExecutionId, error.getMessage()), (Throwable)error);
                }
            });
            this.fail(new QueryExecutionTimedOutException(this.lastQueryExecution, this.queryTimeout));
        }

        void poll() {
            AsyncAthena.this.ensureOpen();
            if (this.hasTimedOut()) {
                this.handleTimeout();
            } else {
                logger.debug("Query execution {} polling for status", this.queryExecutionId);
                ((CompletableFuture)AsyncAthena.this.athenaClient.getQueryExecution(builder -> builder.queryExecutionId(this.queryExecutionId)).thenAccept(this::handleResponse)).exceptionally(this::fail);
            }
        }

        Void fail(Throwable t) {
            Throwable tt = t instanceof CompletionException ? t.getCause() : t;
            logger.warn(String.format("Query execution %s failed polling for status: %s", this.queryExecutionId, tt.getMessage()), tt);
            this.pendingQueryExecution.completeExceptionally(t);
            return null;
        }

        void handleResponse(GetQueryExecutionResponse response) {
            this.lastQueryExecution = response.queryExecution();
            switch (this.lastQueryExecution.status().state()) {
                case SUCCEEDED: {
                    logger.info("Query execution {} has state {}", new Object[]{this.queryExecutionId, this.lastQueryExecution.status().state()});
                    logger.trace("Query execution {} details: {}", this.queryExecutionId, this.lastQueryExecution);
                    this.pendingQueryExecution.complete(this.lastQueryExecution);
                    break;
                }
                case FAILED: 
                case CANCELLED: {
                    logger.info("Query execution {} has state {}", new Object[]{this.queryExecutionId, this.lastQueryExecution.status().state()});
                    logger.trace("Query execution {} details: {}", this.queryExecutionId, this.lastQueryExecution);
                    this.pendingQueryExecution.completeExceptionally(QueryExecutionException.of(this.lastQueryExecution));
                    break;
                }
                default: {
                    this.nextDelay = AsyncAthena.this.pollingStrategy.nextDelay(this.nextDelay);
                    logger.debug("Query execution {} has state {}, will poll again in {} ms", new Object[]{this.queryExecutionId, this.lastQueryExecution.status().state(), this.nextDelay.toMillis()});
                    this.scheduleNextPoll();
                }
            }
        }
    }

    private class AsyncQueryExecutionImpl
    extends CompletableFuture<AsyncQueryResults>
    implements AsyncQueryExecution {
        private final CompletableFuture<String> pendingQueryExecutionId;
        private final AtomicBoolean cancelled;

        AsyncQueryExecutionImpl(CompletableFuture<String> pendingQueryExecutionId) {
            this.pendingQueryExecutionId = pendingQueryExecutionId;
            this.cancelled = new AtomicBoolean(false);
        }

        public CompletableFuture<String> queryExecutionId() {
            return this.pendingQueryExecutionId;
        }

        public CompletableFuture<Boolean> stop() {
            if (!this.isDone() && this.cancelled.compareAndSet(false, true)) {
                return ((CompletableFuture)this.pendingQueryExecutionId.thenCompose((T x$0) -> AsyncAthena.this.stopQueryExecution(x$0))).thenApply((T ignored) -> true);
            }
            logger.debug("Query execution cancellation ignored because query execution already completed or already cancelled", new Object[0]);
            return CompletableFuture.completedFuture(false);
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }

        @Override
        public boolean cancel(boolean ignored) {
            this.stop();
            return this.isCancelled();
        }
    }

    private static class CloseBehavior {
        final boolean closeAthenaClient;
        final boolean shutDownScheduler;

        @Generated
        public CloseBehavior(boolean closeAthenaClient, boolean shutDownScheduler) {
            this.closeAthenaClient = closeAthenaClient;
            this.shutDownScheduler = shutDownScheduler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CloseBehavior)) {
                return false;
            }
            CloseBehavior other = (CloseBehavior)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.closeAthenaClient() != other.closeAthenaClient()) {
                return false;
            }
            return this.shutDownScheduler() == other.shutDownScheduler();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CloseBehavior;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.closeAthenaClient() ? 79 : 97);
            result = result * 59 + (this.shutDownScheduler() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "AsyncAthena.CloseBehavior(closeAthenaClient=" + this.closeAthenaClient() + ", shutDownScheduler=" + this.shutDownScheduler() + ")";
        }

        @Generated
        public boolean closeAthenaClient() {
            return this.closeAthenaClient;
        }

        @Generated
        public boolean shutDownScheduler() {
            return this.shutDownScheduler;
        }
    }
}

