/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.results.AsyncQueryResults;
import com.amazon.athena.client.results.ResultFormatHelper;
import com.amazon.athena.logging.AthenaLogger;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;

abstract class PaginatingAsyncQueryResultsBase
implements AsyncQueryResults {
    private static final AthenaLogger logger = AthenaLogger.of(PaginatingAsyncQueryResultsBase.class);
    private final Executor executor;
    private final List<String[]> initialRows;
    private final QueryExecution queryExecution;
    private final ResultSetMetadata resultSetMetadata;
    private final long updateCount;

    PaginatingAsyncQueryResultsBase(Executor executor, QueryExecution queryExecution, ResultSetMetadata resultSetMetadata, Long updateCount, List<String[]> initialRows) {
        this.executor = executor;
        this.queryExecution = queryExecution;
        this.resultSetMetadata = resultSetMetadata;
        this.updateCount = updateCount == null ? 0L : updateCount;
        this.initialRows = initialRows;
    }

    @Override
    public void subscribe(@NonNull Subscriber<? super String[]> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("subscriber is marked non-null but is null");
        }
        PaginationController paginationController = this.startPagination();
        RowSubscription subscription = new RowSubscription(subscriber, paginationController);
        logger.trace("Got subscriber for query execution {}, starting subscription", this.queryExecution().queryExecutionId());
        subscriber.onSubscribe(subscription);
        subscription.start();
    }

    protected abstract PaginationController startPagination();

    @Override
    @Generated
    public QueryExecution queryExecution() {
        return this.queryExecution;
    }

    @Override
    @Generated
    public ResultSetMetadata resultSetMetadata() {
        return this.resultSetMetadata;
    }

    @Override
    @Generated
    public long updateCount() {
        return this.updateCount;
    }

    private class RowSubscription
    implements Subscription,
    Runnable {
        private final Subscriber<? super String[]> subscriber;
        private final PaginationController paginationController;
        private final AtomicLong requestCount;
        private final AtomicReference<SubscriptionState> subscriptionState;
        private final AtomicBoolean delivering;
        private final AtomicBoolean loading;
        private final AtomicBoolean headersSkipped;
        private final AtomicReference<Throwable> error;
        private final Queue<String[]> rowBuffer;
        private final AtomicInteger bufferSize;

        private RowSubscription(Subscriber<? super String[]> subscriber, PaginationController paginationController) {
            this.subscriber = subscriber;
            this.paginationController = paginationController;
            this.rowBuffer = new ConcurrentLinkedQueue<String[]>();
            this.bufferSize = new AtomicInteger(0);
            this.requestCount = new AtomicLong(0L);
            this.subscriptionState = new AtomicReference<SubscriptionState>(SubscriptionState.NEW);
            this.delivering = new AtomicBoolean(false);
            this.loading = new AtomicBoolean(false);
            this.headersSkipped = new AtomicBoolean(ResultFormatHelper.isPlainTextResult(PaginatingAsyncQueryResultsBase.this.queryExecution));
            this.error = new AtomicReference<Object>(null);
            PaginatingAsyncQueryResultsBase.this.initialRows.forEach(this::addRow);
        }

        private void start() {
            if (this.subscriptionState.compareAndSet(SubscriptionState.NEW, SubscriptionState.SUBSCRIBED)) {
                this.scheduleRun();
            }
        }

        @Override
        public void request(long itemCount) {
            if (itemCount < 0L) {
                logger.warn("Invalid item count requested for query execution {} (got {})", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId(), itemCount);
                this.error.set(new IllegalArgumentException(String.format("Requested item count was negative (got %d)", itemCount)));
                this.scheduleRun();
                return;
            }
            if (itemCount == 0L) {
                logger.warn("Invalid item count requested for query execution {} (got {})", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId(), itemCount);
                this.error.set(new IllegalArgumentException("Requested item count was zero"));
                this.scheduleRun();
                return;
            }
            if (this.subscriptionState.get() != SubscriptionState.CANCELLED) {
                long currentRequestCount = this.requestCount.addAndGet(itemCount);
                logger.trace("Items requested for query execution {} (requested {}, request count is {}, buffer size is {})", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId(), itemCount, currentRequestCount, this.bufferSize.get());
                if (this.requestCount.get() < 0L) {
                    logger.trace("Request count wrapped, all items will be delivered", new Object[0]);
                    this.requestCount.set(Long.MAX_VALUE);
                }
                if (this.requestCount.get() > (long)this.bufferSize.get() && this.paginationController.hasNextPage()) {
                    this.loadNextPage();
                }
                this.scheduleRun();
            } else {
                logger.debug("Items requested for query execution {}, but subscription is cancelled", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId());
            }
        }

        @Override
        public void cancel() {
            logger.trace("Subscription for query execution {} cancelled or completed", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId());
            this.subscriptionState.set(SubscriptionState.CANCELLED);
        }

        private void scheduleRun() {
            if (this.subscriptionState.get() == SubscriptionState.SUBSCRIBED && this.delivering.compareAndSet(false, true)) {
                PaginatingAsyncQueryResultsBase.this.executor.execute(this);
            }
        }

        @Override
        public void run() {
            String[] row;
            logger.trace("Deliver items for query execution {} (request count is {}, buffer size is {})", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId(), this.requestCount.get(), this.bufferSize.get());
            while (this.requestCount.get() > 0L && (row = this.rowBuffer.poll()) != null) {
                try {
                    this.requestCount.decrementAndGet();
                    this.bufferSize.decrementAndGet();
                    this.subscriber.onNext((String[])row);
                }
                catch (Throwable t) {
                    logger.trace("Error caught during item delivery for query execution {}", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId());
                    this.error.set(t);
                    break;
                }
            }
            if (this.error.get() != null) {
                logger.trace("Delivering error for query execution {}", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId());
                this.cancel();
                this.subscriber.onError(this.error.get());
            } else if (this.requestCount.get() > 0L && !this.loading.get()) {
                logger.trace("Item buffer empty for query execution {} (request count is {})", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId(), this.requestCount.get());
                if (this.paginationController.hasNextPage()) {
                    this.loadNextPage();
                } else if (this.rowBuffer.isEmpty()) {
                    logger.trace("No more pages to load for query execution {}, completing subscription", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId());
                    this.cancel();
                    this.subscriber.onComplete();
                }
            }
            this.delivering.set(false);
        }

        private void addRow(String[] row) {
            if (this.headersSkipped.get()) {
                this.rowBuffer.add(row);
                this.bufferSize.incrementAndGet();
            } else {
                this.headersSkipped.set(true);
            }
        }

        private void loadNextPage() {
            SubscriptionState currentState = this.subscriptionState.get();
            if (currentState == SubscriptionState.SUBSCRIBED && this.loading.compareAndSet(false, true)) {
                logger.trace("Loading next page for query execution {} (request count is {}, buffer size is {})", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId(), this.requestCount.get(), this.bufferSize.get());
                this.paginationController.loadNextPage(this::addRow, this.error::set, () -> {
                    this.loading.set(false);
                    logger.trace("Loaded page for query execution {} (request count is {}, buffer size is {}, has next page {})", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId(), this.requestCount.get(), this.bufferSize.get(), this.paginationController.hasNextPage());
                    if (this.error.get() == null && this.requestCount.get() > (long)this.bufferSize.get() && this.paginationController.hasNextPage()) {
                        logger.trace("Page did not fulfill request count for query execution {}, load another page", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId());
                        this.loadNextPage();
                    } else if (this.error.get() != null) {
                        logger.trace("Page loading failed for query execution {}", PaginatingAsyncQueryResultsBase.this.queryExecution.queryExecutionId());
                    }
                    this.scheduleRun();
                });
            }
        }
    }

    private static enum SubscriptionState {
        NEW,
        SUBSCRIBED,
        CANCELLED;

    }

    protected static interface PaginationController {
        public boolean hasNextPage();

        public void loadNextPage(Consumer<String[]> var1, Consumer<Throwable> var2, Runnable var3);
    }
}

