/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results.parsing;

import com.amazon.athena.client.results.ResultPage;
import com.amazon.athena.client.results.parsing.metadata.GetQueryResultsStreamMetadataParser;
import com.amazon.athena.jdbc.support.UncheckedParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.services.athenastreaming.model.GetQueryResultsStreamResponse;
import software.amazon.awssdk.thirdparty.jackson.core.JsonParseException;

public class GetQueryResultsStreamResponseParser {
    private final JsonNodeParser jsonNodeParser;
    private final int pageSize;
    private final GetQueryResultsStreamMetadataParser metadataFetcher;

    public GetQueryResultsStreamResponseParser(int pageSize, GetQueryResultsStreamMetadataParser metadataFetcher) {
        this.pageSize = pageSize;
        this.jsonNodeParser = JsonNodeParser.create();
        this.metadataFetcher = metadataFetcher;
    }

    public ResultPage parse(ResponseInputStream<GetQueryResultsStreamResponse> responsePage) throws ParseException {
        String nextToken;
        ArrayList<String[]> rows;
        ResultSetMetadata resultSetMetadata;
        block18: {
            resultSetMetadata = null;
            rows = new ArrayList<String[]>(this.pageSize);
            int columnCount = -1;
            nextToken = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(responsePage));){
                String line;
                while (true) {
                    if ((line = in.readLine()) == null && resultSetMetadata == null) {
                        resultSetMetadata = (ResultSetMetadata)ResultSetMetadata.builder().build();
                        continue;
                    }
                    if (line == null) {
                        break block18;
                    }
                    if (resultSetMetadata == null) {
                        resultSetMetadata = this.metadataFetcher.getMetadata(line);
                        columnCount = resultSetMetadata.columnInfo().size();
                        continue;
                    }
                    if (!line.startsWith("{")) break;
                    rows.add(this.toRow(columnCount, line));
                }
                nextToken = line.trim().isEmpty() ? null : line;
            }
            catch (UncheckedParseException | IOException | UncheckedIOException e) {
                String message = e.getCause() instanceof JsonParseException ? e.getCause().getMessage().replaceAll("\\n\\s*", " ") : e.getMessage();
                throw new ParseException(String.format("Could not parse streaming page: %s", message), 0);
            }
        }
        return new ResultPage(resultSetMetadata, responsePage.response().updateCount(), rows, nextToken);
    }

    private String[] toRow(int columnCount, String jsonEncodedRow) {
        JsonNode rowJson = this.jsonNodeParser.parse(jsonEncodedRow);
        List data = rowJson.field("data").map(JsonNode::asArray).orElseThrow(() -> new UncheckedParseException("row has no data property"));
        return this.toRow(columnCount, data);
    }

    protected String[] toRow(int columnCount, List<JsonNode> data) {
        if (data.size() != columnCount) {
            throw new UncheckedParseException(String.format("wrong number of columns for row, got %d expected %d", data.size(), columnCount));
        }
        String[] row = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            row[i] = data.get(i).field("varCharValue").map(JsonNode::text).orElse(null);
        }
        return row;
    }
}

