/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results.parsing.metadata;

import com.amazon.athena.jdbc.support.UncheckedParseException;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;

public class GetQueryResultsStreamMetadataParser {
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String SCHEMA_NAME_FIELD = "schemaName";
    private static final String TABLE_NAME_FIELD = "tableName";
    private static final String NAME_FIELD = "name";
    private static final String LABEL_FIELD = "label";
    private static final String TYPE_FIELD = "type";
    private static final String PRECISION_FIELD = "precision";
    private static final String SCALE_FIELD = "scale";
    private static final String NULLABLE_FIELD = "nullable";
    private static final String CASE_SENSITIVE_FIELD = "caseSensitive";
    private final JsonNodeParser jsonNodeParser = JsonNodeParser.create();

    public ResultSetMetadata getMetadata(String json) {
        JsonNode metadataJson = this.jsonNodeParser.parse(json);
        List<ColumnInfo> columnInfos = metadataJson.field("columnInfo").map(JsonNode::asArray).orElseThrow(() -> new UncheckedParseException("metadata has no columnInfo property")).stream().map(this::toColumnInfo).collect(Collectors.toList());
        if (columnInfos.isEmpty()) {
            throw new UncheckedParseException("metadata has no columns");
        }
        return (ResultSetMetadata)ResultSetMetadata.builder().columnInfo(columnInfos).build();
    }

    private ColumnInfo toColumnInfo(JsonNode columnInfoNode) {
        ColumnInfo.Builder columnBuilder = ColumnInfo.builder();
        columnBuilder.catalogName(columnInfoNode.field(CATALOG_NAME_FIELD).map(JsonNode::text).orElse(""));
        columnBuilder.schemaName(columnInfoNode.field(SCHEMA_NAME_FIELD).map(JsonNode::text).orElse(""));
        columnBuilder.tableName(columnInfoNode.field(TABLE_NAME_FIELD).map(JsonNode::text).orElse(""));
        columnBuilder.name(columnInfoNode.field(NAME_FIELD).map(JsonNode::text).orElse(""));
        columnBuilder.label(columnInfoNode.field(LABEL_FIELD).map(JsonNode::text).orElse(""));
        columnBuilder.type(columnInfoNode.field(TYPE_FIELD).map(JsonNode::text).orElse(""));
        columnBuilder.precision(columnInfoNode.field(PRECISION_FIELD).map(JsonNode::text).map(Integer::parseInt).orElse(0));
        columnBuilder.scale(columnInfoNode.field(SCALE_FIELD).map(JsonNode::text).map(Integer::parseInt).orElse(0));
        columnBuilder.nullable(columnInfoNode.field(NULLABLE_FIELD).map(JsonNode::text).orElse(""));
        columnBuilder.caseSensitive(columnInfoNode.field(CASE_SENSITIVE_FIELD).map(JsonNode::text).map(Boolean::valueOf).orElse(false));
        return (ColumnInfo)columnBuilder.build();
    }
}

