/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc;

import com.amazon.athena.jdbc.AthenaConnection;
import com.amazon.athena.jdbc.AthenaParameterMetaData;
import com.amazon.athena.jdbc.AthenaResultSetMetaData;
import com.amazon.athena.jdbc.AthenaStatementBase;
import com.amazon.athena.jdbc.support.sql.ParameterPlaceholderCounter;
import com.amazon.athena.jdbc.support.sql.StatementTypeIdentifier;
import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.utils.IoUtils;

public class AthenaPreparedStatement
extends AthenaStatementBase
implements PreparedStatement {
    private static final AthenaLogger logger = AthenaLogger.of(AthenaPreparedStatement.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateTimeFormatter DATE_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_PATTERN = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter TIMESTAMP_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter DATE_LITERAL_PATTERN = DateTimeFormatter.ofPattern("'DATE '''yyyy-MM-dd''''");
    private static final DateTimeFormatter TIME_LITERAL_PATTERN = DateTimeFormatter.ofPattern("'TIME '''HH:mm:ss''''");
    private static final DateTimeFormatter TIMESTAMP_LITERAL_PATTERN = DateTimeFormatter.ofPattern("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss.SSS''''");
    private final String sql;
    private final ZoneId localTimeZoneId;
    private final ArrayList<String> parameters;
    private final AthenaParameterMetaData parameterMetaData;
    private final boolean isSelect;
    private ResultSetMetaData metaData;

    AthenaPreparedStatement(AthenaConnection connection, String sql) throws SQLException {
        this(connection, sql, ZoneId.systemDefault());
    }

    AthenaPreparedStatement(AthenaConnection connection, String sql, ZoneId localTimeZoneId) throws SQLException {
        super(connection);
        if (sql == null) {
            throw new SQLDataException("A null SQL string is not allowed when creating a prepared statement");
        }
        this.sql = sql;
        this.localTimeZoneId = localTimeZoneId;
        this.metaData = null;
        try {
            int parameterCount = ParameterPlaceholderCounter.countParameterPlaceholders(sql);
            this.parameterMetaData = new AthenaParameterMetaData(parameterCount);
            this.parameters = new ArrayList(parameterCount);
            this.isSelect = StatementTypeIdentifier.isSelect(sql);
        }
        catch (ParseException e) {
            throw new SQLSyntaxErrorException(String.format("Could not parse query to determine parameter count, SQL parsing failed at character %d: %s", e.getErrorOffset(), e.getMessage()), e);
        }
        this.clearParameters();
    }

    private void setParameterValue(int parameterIndex, String stringValue) throws SQLException {
        this.ensureOpen();
        this.parameterMetaData.checkParameterIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, stringValue);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute();
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        int updateCount = this.getUpdateCount();
        return updateCount != -1 ? updateCount : 0;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameterValue(parameterIndex, "NULL");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.setParameterValue(parameterIndex, this.toBooleanLiteral(value));
    }

    private String toBooleanLiteral(boolean value) {
        return String.valueOf(value).toUpperCase();
    }

    @Override
    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.setParameterValue(parameterIndex, String.valueOf(value));
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.setParameterValue(parameterIndex, String.valueOf(value));
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.setParameterValue(parameterIndex, String.valueOf(value));
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.setParameterValue(parameterIndex, String.valueOf(value));
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.setParameterValue(parameterIndex, String.valueOf(value));
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.setParameterValue(parameterIndex, String.valueOf(value));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.setParameterValue(parameterIndex, value.toPlainString());
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.setParameterValue(parameterIndex, this.toStringLiteral(value));
    }

    private String toStringLiteral(String value) {
        return String.format("'%s'", value.replaceAll("'", "''"));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] value) throws SQLException {
        this.setParameterValue(parameterIndex, this.toVarbinaryLiteral(value));
    }

    private String toVarbinaryLiteral(byte[] value) {
        StringBuilder builder = new StringBuilder(value.length * 2 + 3);
        builder.append("X'");
        for (byte b : value) {
            builder.append(Character.forDigit(b >> 4 & 0xF, 16));
            builder.append(Character.forDigit(b & 0xF, 16));
        }
        builder.append("'");
        return builder.toString();
    }

    @Override
    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.setDate(parameterIndex, value, null);
    }

    @Override
    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.setTime(parameterIndex, value, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.setTimestamp(parameterIndex, value, null);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, value, (long)length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream value, int length) throws SQLException {
        if (length <= 65536) {
            try {
                this.setString(parameterIndex, IoUtils.toUtf8String(value));
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage(), e);
            }
        } else {
            throw new SQLException("Cannot set a parameter to a string longer than 65536");
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, value, (long)length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
        for (int i = 0; i < this.parameterMetaData.getParameterCount(); ++i) {
            this.parameters.add(null);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object value, int sqlType) throws SQLException {
        if (value == null || sqlType == 0) {
            this.setNull(parameterIndex, sqlType);
            return;
        }
        try {
            switch (sqlType) {
                case 16: {
                    this.setParameterValue(parameterIndex, this.toBooleanLiteral(value));
                    break;
                }
                case -6: {
                    this.setParameterValue(parameterIndex, this.toTinyintLiteral(value));
                    break;
                }
                case 5: {
                    this.setParameterValue(parameterIndex, this.toSmallintLiteral(value));
                    break;
                }
                case 4: {
                    this.setParameterValue(parameterIndex, this.toIntegerLiteral(value));
                    break;
                }
                case -5: {
                    this.setParameterValue(parameterIndex, this.toBigintLiteral(value));
                    break;
                }
                case 6: 
                case 7: {
                    this.setParameterValue(parameterIndex, this.toFloatLiteral(value));
                    break;
                }
                case 8: {
                    this.setParameterValue(parameterIndex, this.toDoubleLiteral(value));
                    break;
                }
                case 2: 
                case 3: {
                    this.setParameterValue(parameterIndex, this.toDecimalLiteral(value));
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    this.setParameterValue(parameterIndex, this.toStringLiteral(value));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.setParameterValue(parameterIndex, this.toVarbinaryLiteral(value));
                    break;
                }
                case 91: {
                    this.setParameterValue(parameterIndex, this.toDateLiteral(value, this.localTimeZoneId));
                    break;
                }
                case 92: {
                    this.setParameterValue(parameterIndex, this.toTimeLiteral(value, this.localTimeZoneId));
                    break;
                }
                case 93: {
                    this.setParameterValue(parameterIndex, this.toTimestampLiteral(value, this.localTimeZoneId));
                    break;
                }
                case 2003: {
                    this.setParameterValue(parameterIndex, this.toArrayLiteral(value));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("the %s type is not supported", JDBCType.valueOf(sqlType)));
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(String.format("Cannot set object value, %s", e.getMessage()));
        }
    }

    private String toBooleanLiteral(Object value) {
        if (value instanceof Boolean) {
            return this.toBooleanLiteral((Boolean)value);
        }
        if (value instanceof Number) {
            double n = ((Number)value).doubleValue();
            if (n == 1.0) {
                return this.toBooleanLiteral(true);
            }
            if (n == 0.0) {
                return this.toBooleanLiteral(false);
            }
        } else if (value instanceof Character || value instanceof CharSequence) {
            String s = value.toString();
            boolean isFalsy = s.isEmpty() || s.equalsIgnoreCase("false") || s.equalsIgnoreCase("0");
            return this.toBooleanLiteral(!isFalsy);
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a boolean", value));
    }

    private String toTinyintLiteral(Object value) {
        if (value instanceof Byte) {
            return String.valueOf(((Byte)value).byteValue());
        }
        if (value instanceof Number) {
            long n = ((Number)value).longValue();
            if (n <= 127L && n >= -128L) {
                return String.valueOf(n);
            }
        } else {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "1" : "0";
            }
            if (value instanceof Character || value instanceof CharSequence) {
                try {
                    return String.valueOf(Byte.parseByte(value.toString()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a byte", value));
    }

    private String toSmallintLiteral(Object value) {
        if (value instanceof Short) {
            return String.valueOf(((Short)value).shortValue());
        }
        if (value instanceof Number) {
            long n = ((Number)value).longValue();
            if (n <= 32767L && n >= -32768L) {
                return String.valueOf(n);
            }
        } else {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "1" : "0";
            }
            if (value instanceof Character || value instanceof CharSequence) {
                try {
                    return String.valueOf(Short.parseShort(value.toString()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a short", value));
    }

    private String toIntegerLiteral(Object value) {
        if (value instanceof Integer) {
            return String.valueOf((Integer)value);
        }
        if (value instanceof Number) {
            long n = ((Number)value).longValue();
            if (n <= Integer.MAX_VALUE && n >= Integer.MIN_VALUE) {
                return String.valueOf(n);
            }
        } else {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "1" : "0";
            }
            if (value instanceof Character || value instanceof CharSequence) {
                try {
                    return String.valueOf(Integer.parseInt(value.toString()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to an integer", value));
    }

    private String toBigintLiteral(Object value) {
        if (value instanceof Long) {
            return String.valueOf((Long)value);
        }
        if (value instanceof BigDecimal) {
            BigDecimal n = (BigDecimal)value;
            try {
                return String.valueOf(n.longValueExact());
            }
            catch (ArithmeticException arithmeticException) {
            }
        } else {
            if (value instanceof Number) {
                return String.valueOf(((Number)value).longValue());
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "1" : "0";
            }
            if (value instanceof Character || value instanceof CharSequence) {
                try {
                    return String.valueOf(Long.parseLong(value.toString()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a long", value));
    }

    private String toFloatLiteral(Object value) {
        if (value instanceof Float) {
            return String.valueOf(((Float)value).floatValue());
        }
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (d <= 3.4028234663852886E38 && d >= (double)1.4E-45f) {
                return String.valueOf(d);
            }
        } else {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "1.0" : "0.0";
            }
            if (value instanceof Character || value instanceof CharSequence) {
                try {
                    return String.valueOf(Float.parseFloat(value.toString()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a float", value));
    }

    private String toDoubleLiteral(Object value) {
        if (value instanceof Double) {
            return String.valueOf((Double)value);
        }
        if (value instanceof Number) {
            return String.valueOf(((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1.0" : "0.0";
        }
        if (value instanceof Character || value instanceof CharSequence) {
            try {
                return String.valueOf(Double.parseDouble(value.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a double", value));
    }

    private String toDecimalLiteral(Object value) {
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : "0";
        }
        if (value instanceof Character || value instanceof CharSequence) {
            try {
                return new BigDecimal(value.toString()).toString();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a decimal", value));
    }

    private String toStringLiteral(Object value) throws SQLException {
        if (value instanceof InputStream) {
            return this.toStringLiteral((InputStream)value);
        }
        if (value instanceof Reader) {
            return this.toStringLiteral((Reader)value);
        }
        return this.toStringLiteral(value.toString());
    }

    private String toStringLiteral(InputStream value) throws SQLException {
        try {
            return this.toStringLiteral(IoUtils.toUtf8String(value));
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    private String toStringLiteral(Reader value) throws SQLException {
        char[] buffer = new char[8192];
        StringBuilder str = new StringBuilder();
        try {
            int charsRead;
            while ((charsRead = value.read(buffer, 0, buffer.length)) != -1) {
                str.append(buffer, 0, charsRead);
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
        return this.toStringLiteral(str.toString());
    }

    private String toVarbinaryLiteral(Object value) throws SQLException {
        if (value instanceof byte[]) {
            return this.toVarbinaryLiteral((byte[])value);
        }
        if (value instanceof InputStream) {
            return this.toVarbinaryLiteral((InputStream)value);
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return this.toVarbinaryLiteral(value.toString().getBytes(StandardCharsets.UTF_8));
        }
        if (value instanceof Character || value instanceof Character) {
            return this.toVarbinaryLiteral(String.valueOf(((Character)value).charValue()).getBytes(StandardCharsets.UTF_8));
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a varbinary", value));
    }

    private String toDateLiteral(Object value, ZoneId targetZoneId) {
        if (value instanceof Date) {
            return this.toDateLiteral((Date)value, targetZoneId);
        }
        if (value instanceof java.util.Date && !(value instanceof Time)) {
            Instant instant = ((java.util.Date)value).toInstant();
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.localTimeZoneId);
            return this.toDateLiteral(zdt, targetZoneId);
        }
        if (value instanceof Instant) {
            ZonedDateTime zdt = ZonedDateTime.ofInstant((Instant)value, this.localTimeZoneId);
            return this.toDateLiteral(zdt, targetZoneId);
        }
        if (value instanceof LocalDate) {
            LocalDate d = (LocalDate)value;
            ZonedDateTime zdt = ZonedDateTime.of(d, LocalTime.MIN, this.localTimeZoneId);
            return this.toDateLiteral(zdt, targetZoneId);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime dt = (LocalDateTime)value;
            ZonedDateTime zdt = ZonedDateTime.of(dt, this.localTimeZoneId);
            return this.toDateLiteral(zdt, targetZoneId);
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)value;
            ZonedDateTime zdt = odt.atZoneSameInstant(this.localTimeZoneId);
            return this.toDateLiteral(zdt, targetZoneId);
        }
        if (value instanceof ZonedDateTime) {
            return this.toDateLiteral((ZonedDateTime)value, targetZoneId);
        }
        if (value instanceof Character || value instanceof CharSequence) {
            try {
                LocalDate d = LocalDate.parse(value.toString(), DATE_PATTERN);
                ZonedDateTime zdt = ZonedDateTime.of(d, LocalTime.MIN, this.localTimeZoneId);
                return this.toDateLiteral(zdt, targetZoneId);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a date", value));
    }

    private String toTimeLiteral(Object value, ZoneId targetZoneId) {
        if (value instanceof Time) {
            return this.toTimeLiteral((Time)value, targetZoneId);
        }
        if (value instanceof java.util.Date && !(value instanceof Date)) {
            Instant instant = ((java.util.Date)value).toInstant();
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.localTimeZoneId);
            return this.toTimeLiteral(zdt, targetZoneId);
        }
        if (value instanceof Instant) {
            ZonedDateTime zdt = ZonedDateTime.ofInstant((Instant)value, this.localTimeZoneId);
            return this.toTimeLiteral(zdt, targetZoneId);
        }
        if (value instanceof LocalTime) {
            LocalTime t = (LocalTime)value;
            LocalDateTime dt = t.atDate(LocalDate.now(this.localTimeZoneId));
            ZonedDateTime zdt = dt.atZone(this.localTimeZoneId);
            return this.toTimeLiteral(zdt, targetZoneId);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime dt = (LocalDateTime)value;
            ZonedDateTime zdt = ZonedDateTime.of(dt, this.localTimeZoneId);
            return this.toTimeLiteral(zdt, targetZoneId);
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)value;
            ZonedDateTime zdt = odt.atZoneSameInstant(this.localTimeZoneId);
            return this.toTimeLiteral(zdt, targetZoneId);
        }
        if (value instanceof ZonedDateTime) {
            return this.toTimeLiteral((ZonedDateTime)value, targetZoneId);
        }
        if (value instanceof Character || value instanceof CharSequence) {
            try {
                LocalTime t = LocalTime.parse(value.toString(), TIME_PATTERN);
                ZonedDateTime zdt = ZonedDateTime.of(LocalDate.now(this.localTimeZoneId), t, this.localTimeZoneId);
                return this.toTimeLiteral(zdt, targetZoneId);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a time", value));
    }

    private String toTimestampLiteral(Object value, ZoneId targetZoneId) {
        if (value instanceof java.util.Date) {
            Instant instant = ((java.util.Date)value).toInstant();
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.localTimeZoneId);
            return this.toTimestampLiteral(zdt, targetZoneId);
        }
        if (value instanceof Instant) {
            ZonedDateTime zdt = ZonedDateTime.ofInstant((Instant)value, this.localTimeZoneId);
            return this.toTimestampLiteral(zdt, targetZoneId);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime dt = (LocalDateTime)value;
            ZonedDateTime zdt = dt.atZone(this.localTimeZoneId);
            return this.toTimestampLiteral(zdt, targetZoneId);
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)value;
            ZonedDateTime zdt = odt.atZoneSameInstant(this.localTimeZoneId);
            return this.toTimestampLiteral(zdt, targetZoneId);
        }
        if (value instanceof ZonedDateTime) {
            return this.toTimestampLiteral((ZonedDateTime)value, targetZoneId);
        }
        if (value instanceof Character || value instanceof CharSequence) {
            try {
                LocalDateTime dt = LocalDateTime.parse(value.toString(), TIMESTAMP_PATTERN);
                ZonedDateTime zdt = dt.atZone(this.localTimeZoneId);
                return this.toTimestampLiteral(zdt, targetZoneId);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to a timestamp", value));
    }

    private String toArrayLiteral(Object value) throws SQLException {
        if (value instanceof Array) {
            return this.toArrayLiteral((Array)value);
        }
        throw new IllegalArgumentException(String.format("\"%s\" cannot be converted to an array", value));
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        if (value == null) {
            this.setNull(parameterIndex, 0);
        } else if (value instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByte(parameterIndex, (Byte)value);
        } else if (value instanceof Short) {
            this.setShort(parameterIndex, (Short)value);
        } else if (value instanceof Integer) {
            this.setInt(parameterIndex, (Integer)value);
        } else if (value instanceof Long) {
            this.setLong(parameterIndex, (Long)value);
        } else if (value instanceof Float) {
            this.setFloat(parameterIndex, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(parameterIndex, (Double)value);
        } else if (value instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)value);
        } else if (value instanceof Character || value instanceof CharSequence) {
            this.setString(parameterIndex, value.toString());
        } else if (value instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])value);
        } else if (value instanceof Date || value instanceof LocalDate) {
            this.setParameterValue(parameterIndex, this.toDateLiteral(value, this.localTimeZoneId));
        } else if (value instanceof Time || value instanceof LocalTime) {
            this.setParameterValue(parameterIndex, this.toTimeLiteral(value, this.localTimeZoneId));
        } else if (value instanceof Timestamp || value instanceof java.util.Date || value instanceof LocalDateTime || value instanceof ZonedDateTime || value instanceof OffsetDateTime || value instanceof Instant) {
            this.setParameterValue(parameterIndex, this.toTimestampLiteral(value, this.localTimeZoneId));
        } else if (value instanceof Array) {
            this.setArray(parameterIndex, (Array)value);
        } else {
            throw new SQLException(String.format("Cannot set object value, %s is not a supported object type", value.getClass().getName()));
        }
    }

    @Override
    public boolean execute() throws SQLException {
        List<String> parametersSnapshot = Collections.unmodifiableList(new ArrayList<String>(this.parameters));
        this.resultSet = this.runQuery(this.sql, parametersSnapshot);
        return !this.resultSet.hasUpdateCount();
    }

    @Override
    public void addBatch() throws SQLException {
        this.addBatch(this.sql);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, (long)length);
    }

    @Override
    public void setRef(int parameterIndex, Ref value) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Ref type is not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob value) throws SQLException {
        this.setBlob(parameterIndex, value.getBinaryStream(), value.length());
    }

    @Override
    public void setClob(int parameterIndex, Clob value) throws SQLException {
        this.setCharacterStream(parameterIndex, value.getCharacterStream(), value.length());
    }

    @Override
    public void setArray(int parameterIndex, Array value) throws SQLException {
        if (value == null) {
            this.setNull(parameterIndex, 2003);
            return;
        }
        this.setParameterValue(parameterIndex, this.toArrayLiteral(value));
    }

    private String toArrayLiteral(Array value) throws SQLException {
        StringBuilder str = new StringBuilder("ARRAY[");
        ResultSet rs = value.getResultSet();
        while (rs.next()) {
            if (!rs.isFirst()) {
                str.append(", ");
            }
            str.append(this.toArrayElement(value, rs));
        }
        str.append("]");
        return str.toString();
    }

    private String toArrayElement(Array array, ResultSet resultSet) throws SQLException {
        switch (array.getBaseType()) {
            case -7: 
            case -6: 
            case -5: 
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return resultSet.getString(2);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.toStringLiteral(resultSet.getString(2));
            }
            case -4: 
            case -3: 
            case -2: {
                return this.toVarbinaryLiteral(resultSet.getBytes(2));
            }
            case 91: {
                return String.format("DATE '%s'", resultSet.getString(2));
            }
            case 92: {
                return String.format("TIME '%s'", resultSet.getString(2));
            }
            case 93: {
                return String.format("TIMESTAMP '%s'", resultSet.getString(2));
            }
        }
        throw new SQLFeatureNotSupportedException(String.format("Arrays with base type %s are not supported", array.getBaseTypeName()));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultSet != null) {
            return this.resultSet.getMetaData();
        }
        if (this.metaData == null) {
            if (this.isSelect) {
                List<String> nullParameters = this.parameters.stream().map(ignored -> "NULL").collect(Collectors.toList());
                this.metaData = this.runQuery(String.format("-- Athena JDBC driver prepared statement metadata\nSELECT * FROM (%s) LIMIT 0", this.sql), nullParameters).getMetaData();
            } else {
                logger.info("Prepared statement metadata was not loaded because the query was not a SELECT statement", new Object[0]);
                this.metaData = new AthenaResultSetMetaData((ResultSetMetadata)ResultSetMetadata.builder().build());
            }
        }
        return this.metaData;
    }

    private ZoneId calendarOrLocalZoneId(Calendar calendar) {
        return calendar == null ? this.localTimeZoneId : calendar.getTimeZone().toZoneId();
    }

    @Override
    public void setDate(int parameterIndex, Date value, Calendar calendar) throws SQLException {
        this.setParameterValue(parameterIndex, this.toDateLiteral(value, this.calendarOrLocalZoneId(calendar)));
    }

    private String toDateLiteral(Date value, ZoneId targetZoneId) {
        Instant instant = Instant.ofEpochMilli(value.getTime());
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.localTimeZoneId);
        ZonedDateTime midnight = ZonedDateTime.of(zdt.toLocalDate(), LocalTime.MIN, this.localTimeZoneId);
        return this.toDateLiteral(midnight, targetZoneId);
    }

    private String toDateLiteral(ZonedDateTime value, ZoneId targetZoneId) {
        return this.formatDateTime(value, targetZoneId, DATE_LITERAL_PATTERN);
    }

    @Override
    public void setTime(int parameterIndex, Time value, Calendar calendar) throws SQLException {
        this.setParameterValue(parameterIndex, this.toTimeLiteral(value, this.calendarOrLocalZoneId(calendar)));
    }

    private String toTimeLiteral(Time value, ZoneId targetZoneId) {
        Instant instant = Instant.ofEpochMilli(value.getTime());
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.localTimeZoneId);
        return this.toTimeLiteral(zdt, targetZoneId);
    }

    private String toTimeLiteral(ZonedDateTime value, ZoneId targetZoneId) {
        return this.formatDateTime(value, targetZoneId, TIME_LITERAL_PATTERN);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value, Calendar calendar) throws SQLException {
        this.setParameterValue(parameterIndex, this.toTimestampLiteral(value, this.calendarOrLocalZoneId(calendar)));
    }

    private String toTimestampLiteral(Timestamp value, ZoneId targetZoneId) {
        Instant instant = Instant.ofEpochMilli(value.getTime());
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.localTimeZoneId);
        return this.toTimestampLiteral(zdt, targetZoneId);
    }

    private String toTimestampLiteral(ZonedDateTime value, ZoneId targetZoneId) {
        return this.formatDateTime(value, targetZoneId, TIMESTAMP_LITERAL_PATTERN);
    }

    private String formatDateTime(ZonedDateTime value, ZoneId targetZoneId, DateTimeFormatter format) {
        return format.format(value.withZoneSameInstant(targetZoneId));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL value) throws SQLException {
        this.setString(parameterIndex, value.toString());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    @Override
    public void setRowId(int parameterIndex, RowId value) throws SQLException {
        throw new SQLFeatureNotSupportedException("The RowId type is not supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setCharacterStream(parameterIndex, value.getCharacterStream(), value.length());
    }

    @Override
    public void setClob(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream value, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML value) throws SQLException {
        throw new SQLFeatureNotSupportedException("The SQLXML type is not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object value, int sqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("Setting object parameters with the scale parameter is not supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, long length) throws SQLException {
        if (length > 65536L && length != Long.MAX_VALUE) {
            throw new SQLException("Cannot set a parameter to a string longer than 65536");
        }
        this.setParameterValue(parameterIndex, this.toStringLiteral(value));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, long length) throws SQLException {
        if (length > 65536L && length != Long.MAX_VALUE) {
            throw new SQLException("Cannot set a parameter to a varbinary longer than 65536");
        }
        this.setParameterValue(parameterIndex, this.toVarbinaryLiteral(value));
    }

    private String toVarbinaryLiteral(InputStream value) throws SQLException {
        try {
            return this.toVarbinaryLiteral(IoUtils.toByteArray(value));
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (length > 65536L && length != Long.MAX_VALUE) {
            throw new SQLException("Cannot set a parameter to a string longer than 65536");
        }
        this.setParameterValue(parameterIndex, this.toStringLiteral(value));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value) throws SQLException {
        this.setAsciiStream(parameterIndex, value, Long.MAX_VALUE);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        this.setBinaryStream(parameterIndex, value, Long.MAX_VALUE);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value, Long.MAX_VALUE);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setNCharacterStream(parameterIndex, value, Long.MAX_VALUE);
    }

    @Override
    public void setClob(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream value) throws SQLException {
        this.setBinaryStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cannot execute a prepared statement with a query string");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cannot execute a prepared statement with a query string");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cannot execute a prepared statement with a query string");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cannot execute a prepared statement with a query string");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cannot execute a prepared statement with a query string");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cannot execute a prepared statement with a query string");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cannot execute a prepared statement with a query string");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cannot execute a prepared statement with a query string");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cannot execute a prepared statement with a query string");
    }
}

