/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.IdpCredentialsProvider;
import com.amazon.athena.jdbc.authentication.SamlCredentialsProvider;
import com.amazon.athena.jdbc.authentication.utils.AzureAdAuthUtils;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.support.AuthenticationException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lakeformation.LakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import software.amazon.awssdk.utils.StringUtils;

public class AzureAdCredentialsProvider
extends SamlCredentialsProvider {
    private static final String URI_TEMPLATE = "https://login.microsoftonline.com/%s/oauth2/token";
    private final String username;
    private final String password;
    private final String tenantId;
    private final String clientSecret;
    private final String clientId;
    private final Supplier<CloseableHttpClient> httpClientFactory;

    private AzureAdCredentialsProvider(String username, String password, String tenantId, String clientId, String clientSecret, String preferredRole, Integer roleSessionDuration, Region region, Supplier<CloseableHttpClient> httpClientFactory, AssumeRoleWithSamlRequest.Builder assumeRoleRequestFactory, StsClientBuilder stsClientFactory, AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleRequestFactory, LakeFormationClientBuilder lakeFormationClientFactory, boolean lakeFormationEnabled, Map<ConnectionParameter<?>, String> parameters) {
        super(assumeRoleRequestFactory, assumeDecoratedRoleRequestFactory, stsClientFactory, lakeFormationClientFactory, null, null, preferredRole, roleSessionDuration, region, lakeFormationEnabled, parameters);
        this.username = username;
        this.password = password;
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.httpClientFactory = httpClientFactory == null ? () -> IdpCredentialsProvider.createHttpClient(parameters) : httpClientFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String getSamlAssertion() {
        URI uri = this.constructAzureAdEndpoint();
        HttpPost post = this.createSamlRequest(uri);
        String responseContent = this.fetchSamlAssertion(post);
        String encodedSamlAssertion = AzureAdAuthUtils.extractAzureAdSamlAssertion(responseContent);
        return AzureAdAuthUtils.wrapAndEncodeAssertion(encodedSamlAssertion);
    }

    private URI constructAzureAdEndpoint() {
        try {
            return new URI(String.format(URI_TEMPLATE, this.tenantId));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Could not construct an AzureAD endpoint from the provided tenant ID (\"%s\"), the URL \"%s\" is invalid", this.tenantId, String.format(URI_TEMPLATE, this.tenantId)), e);
        }
    }

    private HttpPost createSamlRequest(URI endpointUri) {
        HttpPost post = new HttpPost(endpointUri);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(7);
        parameters.add(new BasicNameValuePair("grant_type", "password"));
        parameters.add(new BasicNameValuePair("requested_token_type", "urn:ietf:params:oauth:token-type:saml2"));
        parameters.add(new BasicNameValuePair("username", this.username));
        parameters.add(new BasicNameValuePair("password", this.password));
        parameters.add(new BasicNameValuePair("client_secret", this.clientSecret));
        parameters.add(new BasicNameValuePair("client_id", this.clientId));
        parameters.add(new BasicNameValuePair("resource", this.clientId));
        post.addHeader("Content-Type", "application/x-www-form-urlencoded");
        post.addHeader("Accept", "application/json");
        post.setEntity(new UrlEncodedFormEntity(parameters, Charset.forName("UTF-8")));
        return post;
    }

    /*
     * Exception decompiling
     */
    private String fetchSamlAssertion(HttpPost request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateSamlResponse(CloseableHttpResponse response) {
        if (response.getStatusLine().getStatusCode() != 200) {
            String content = AzureAdCredentialsProvider.extractResponseBody(response);
            JsonNode entityJson = JsonNodeParser.create().parse(content);
            String errorDescription = entityJson.field("error_description").map(JsonNode::text).orElse("");
            if (!StringUtils.isEmpty(errorDescription)) {
                errorDescription = errorDescription.replaceAll("\r\n", " ");
                String errorName = entityJson.field("error").map(JsonNode::text).orElse("");
                if (!StringUtils.isEmpty(errorName)) {
                    throw new AuthenticationException(errorName + " -- " + errorDescription);
                }
                throw new AuthenticationException("Unexpected response -- " + errorDescription);
            }
            throw new AuthenticationException(String.format("Unexpected error while requesting SAML assertion from Azure AD (HTTP response status code %s)", response.getStatusLine().getStatusCode()));
        }
    }

    private static String extractResponseBody(CloseableHttpResponse response) {
        try {
            return EntityUtils.toString(response.getEntity());
        }
        catch (IOException e) {
            throw new AuthenticationException("An error occurred while processing the response from Azure AD", e);
        }
    }

    public static class Builder {
        private String username;
        private String password;
        private String tenantId;
        private String clientId;
        private String clientSecret;
        private String preferredRole;
        private Integer roleSessionDuration;
        private Region region;
        private boolean lakeFormationEnabled;
        private Supplier<CloseableHttpClient> httpClientFactory;
        private AssumeRoleWithSamlRequest.Builder assumeRoleWithSamlRequestFactory;
        private AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleWithSamlRequestFactory;
        private StsClientBuilder stsClientFactory;
        private LakeFormationClientBuilder lakeFormationClientFactory;
        private Map<ConnectionParameter<?>, String> parameters;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder preferredRole(String preferredRole) {
            this.preferredRole = preferredRole;
            return this;
        }

        public Builder roleSessionDuration(Integer roleSessionDuration) {
            this.roleSessionDuration = roleSessionDuration;
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder lakeFormationEnabled(boolean lakeFormationEnabled) {
            this.lakeFormationEnabled = lakeFormationEnabled;
            return this;
        }

        Builder httpClientFactory(Supplier<CloseableHttpClient> httpClientFactory) {
            this.httpClientFactory = httpClientFactory;
            return this;
        }

        Builder assumeRoleWithSamlRequestFactory(AssumeRoleWithSamlRequest.Builder assumeRoleWithSamlRequestFactory) {
            this.assumeRoleWithSamlRequestFactory = assumeRoleWithSamlRequestFactory;
            return this;
        }

        Builder assumeDecoratedRoleWithSamlRequestFactory(AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleWithSamlRequestFactory) {
            this.assumeDecoratedRoleWithSamlRequestFactory = assumeDecoratedRoleWithSamlRequestFactory;
            return this;
        }

        Builder stsClientBuilder(StsClientBuilder stsClientFactory) {
            this.stsClientFactory = stsClientFactory;
            return this;
        }

        Builder lakeFormationClientBuilder(LakeFormationClientBuilder lakeFormationClientFactory) {
            this.lakeFormationClientFactory = lakeFormationClientFactory;
            return this;
        }

        public Builder connectionParameters(Map<ConnectionParameter<?>, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public AzureAdCredentialsProvider build() {
            return new AzureAdCredentialsProvider(this.username, this.password, this.tenantId, this.clientId, this.clientSecret, this.preferredRole, this.roleSessionDuration, this.region, this.httpClientFactory, this.assumeRoleWithSamlRequestFactory, this.stsClientFactory, this.assumeDecoratedRoleWithSamlRequestFactory, this.lakeFormationClientFactory, this.lakeFormationEnabled, this.parameters);
        }
    }
}

