/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.IdpCredentialsProvider;
import com.amazon.athena.jdbc.authentication.SamlCredentialsProvider;
import com.amazon.athena.jdbc.authentication.http.BrowserAuthenticationServer;
import com.amazon.athena.jdbc.authentication.utils.AzureAdAuthUtils;
import com.amazon.athena.jdbc.authentication.utils.RandomString;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lakeformation.LakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;

public class BrowserAzureCredentialsProvider
extends SamlCredentialsProvider {
    private static final AthenaLogger logger = AthenaLogger.of(BrowserAzureCredentialsProvider.class);
    private static final int DEFAULT_STATE_STRING_LENGTH = 10;
    private String tenantId;
    private String clientId;
    private int idpResponseTimeout;
    private final Desktop desktop;
    private final String randomState;
    private final BrowserAuthenticationServer server;
    private final Supplier<CloseableHttpClient> httpClientFactory;

    private BrowserAzureCredentialsProvider(String tenantId, String clientId, String preferredRole, Integer roleSessionDuration, Region region, Supplier<CloseableHttpClient> httpClientFactory, AssumeRoleWithSamlRequest.Builder assumeRoleRequestFactory, StsClientBuilder stsClientFactory, AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleRequestFactory, LakeFormationClientBuilder lfClientFactory, boolean lakeFormationEnabled, int idpResponseTimeout, Desktop desktop, BrowserAuthenticationServer server, String randomState, Map<ConnectionParameter<?>, String> parameters) {
        super(assumeRoleRequestFactory, assumeDecoratedRoleRequestFactory, stsClientFactory, lfClientFactory, null, null, preferredRole, roleSessionDuration, region, lakeFormationEnabled, parameters);
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.idpResponseTimeout = idpResponseTimeout;
        this.desktop = desktop == null ? Desktop.getDesktop() : desktop;
        this.server = server == null ? new BrowserAuthenticationServer(0) : server;
        this.randomState = randomState == null ? RandomString.generateRandomString(10) : randomState;
        this.httpClientFactory = httpClientFactory == null ? () -> IdpCredentialsProvider.createHttpClient(parameters) : httpClientFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String getSamlAssertion() {
        String token = this.fetchAuthorizationToken();
        String content = this.fetchSamlResponse(token);
        String samlAssertion = AzureAdAuthUtils.extractAzureAdSamlAssertion(content);
        return AzureAdAuthUtils.wrapAndEncodeAssertion(samlAssertion);
    }

    private String fetchAuthorizationToken() {
        Future<List<NameValuePair>> future = this.server.listenForResponse();
        String redirectUri = this.server.getServerUrl();
        try {
            URI requestUri = this.createCodeRequestUri(this.randomState, redirectUri);
            logger.info(String.format("Open URI: %s", requestUri.toString()), new Object[0]);
            this.desktop.browse(requestUri);
            List<NameValuePair> response = future.get(this.idpResponseTimeout, TimeUnit.SECONDS);
            String receivedState = this.findValueInNameValuePairs("state", response).orElseThrow(() -> new AuthenticationException("State is not found in the response."));
            if (!this.randomState.equals(receivedState)) {
                String message = "State mismatch, incoming: " + receivedState + ", generated: " + this.randomState;
                throw new AuthenticationException(message);
            }
            String string = this.findValueInNameValuePairs("code", response).filter(value -> !value.isEmpty()).orElseThrow(() -> new AuthenticationException("Authorization code is not found or empty."));
            return string;
        }
        catch (TimeoutException ex) {
            future.cancel(true);
            throw new AuthenticationException("Couldn't fetch code within timeout window.");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            logger.debug("Main thread got interrupted: {}", ex.getMessage());
            throw new AuthenticationException("Main thread got interrupted.", ex);
        }
        catch (ExecutionException ex) {
            logger.debug("Server thread throw an exception: {}", ex.getMessage());
            throw new AuthenticationException(ex.getMessage());
        }
        catch (IOException | URISyntaxException ex) {
            logger.debug("Server thread throw an exception: {}", ex.getMessage());
            throw new AuthenticationException(ex.getMessage());
        }
        finally {
            logger.trace("Shutdown listening server.", new Object[0]);
            this.server.shutdownServer();
        }
    }

    /*
     * Exception decompiling
     */
    private String fetchSamlResponse(String token) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpPost createAuthorizationRequest(String authorizationCode) {
        String tokenRequestUrl = this.createTokenRequestUri();
        HttpPost post = new HttpPost(tokenRequestUrl);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("code", authorizationCode));
        parameters.add(new BasicNameValuePair("requested_token_type", "urn:ietf:params:oauth:token-type:saml2"));
        parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
        parameters.add(new BasicNameValuePair("scope", "openid"));
        parameters.add(new BasicNameValuePair("resource", this.clientId));
        parameters.add(new BasicNameValuePair("client_id", this.clientId));
        String redirectUri = this.server.getServerUrl();
        parameters.add(new BasicNameValuePair("redirect_uri", redirectUri));
        post.addHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
        post.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
        post.setEntity(new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8));
        return post;
    }

    private static String extractResponseBody(CloseableHttpResponse response) {
        try {
            return EntityUtils.toString(response.getEntity());
        }
        catch (IOException ex) {
            throw new AuthenticationException("An error occurred while processing the response from Azure AD", ex);
        }
    }

    private String createTokenRequestUri() {
        URIBuilder builder = new URIBuilder().setScheme("https").setHost("login.microsoftonline.com").setPath("/" + this.tenantId + "/oauth2/token");
        return builder.toString();
    }

    private URI createCodeRequestUri(String state, String redirectUri) throws URISyntaxException {
        URIBuilder builder = new URIBuilder().setScheme("https").setHost("login.microsoftonline.com").setPath("/" + this.tenantId + "/oauth2/authorize").addParameter("scope", "openid").addParameter("response_type", "code").addParameter("response_mode", "form_post").addParameter("client_id", this.clientId).addParameter("redirect_uri", redirectUri).addParameter("state", state);
        return builder.build();
    }

    public static class Builder {
        private String tenantId;
        private String clientId;
        private String preferredRole;
        private Integer roleSessionDuration;
        private Integer idpResponseTimeout;
        private Region region;
        private boolean lakeFormationEnabled;
        private Desktop desktop;
        private String randomState;
        private BrowserAuthenticationServer server;
        private Supplier<CloseableHttpClient> httpClientFactory;
        private AssumeRoleWithSamlRequest.Builder stsAssumeRoleFactory;
        private AssumeDecoratedRoleWithSamlRequest.Builder lfAssumeRoleFactory;
        private StsClientBuilder stsClientFactory;
        private LakeFormationClientBuilder lfClientFactory;
        private Map<ConnectionParameter<?>, String> parameters;

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder preferredRole(String preferredRole) {
            this.preferredRole = preferredRole;
            return this;
        }

        public Builder roleSessionDuration(Integer roleSessionDuration) {
            this.roleSessionDuration = roleSessionDuration;
            return this;
        }

        public Builder idpResponseTimeout(Integer idpResponseTimeout) {
            this.idpResponseTimeout = idpResponseTimeout;
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder lakeFormationEnabled(boolean lakeFormationEnabled) {
            this.lakeFormationEnabled = lakeFormationEnabled;
            return this;
        }

        public Builder connectionParameters(Map<ConnectionParameter<?>, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        Builder httpClientFactory(Supplier<CloseableHttpClient> factory) {
            this.httpClientFactory = factory;
            return this;
        }

        Builder assumeRoleWithSamlRequestFactory(AssumeRoleWithSamlRequest.Builder factory) {
            this.stsAssumeRoleFactory = factory;
            return this;
        }

        Builder assumeDecoratedRoleWithSamlRequestFactory(AssumeDecoratedRoleWithSamlRequest.Builder factory) {
            this.lfAssumeRoleFactory = factory;
            return this;
        }

        Builder stsClientBuilder(StsClientBuilder factory) {
            this.stsClientFactory = factory;
            return this;
        }

        Builder lakeFormationClientBuilder(LakeFormationClientBuilder factory) {
            this.lfClientFactory = factory;
            return this;
        }

        Builder browser(Desktop desktop) {
            this.desktop = desktop;
            return this;
        }

        Builder randomState(String randomState) {
            this.randomState = randomState;
            return this;
        }

        Builder server(BrowserAuthenticationServer server) {
            this.server = server;
            return this;
        }

        public BrowserAzureCredentialsProvider build() {
            return new BrowserAzureCredentialsProvider(this.tenantId, this.clientId, this.preferredRole, this.roleSessionDuration, this.region, this.httpClientFactory, this.stsAssumeRoleFactory, this.stsClientFactory, this.lfAssumeRoleFactory, this.lfClientFactory, this.lakeFormationEnabled, this.idpResponseTimeout, this.desktop, this.server, this.randomState, this.parameters);
        }
    }
}

