/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.JwtTrustedIdentityPropagationCredentialsProvider;
import com.amazon.athena.jdbc.authentication.TrustedIdentityPropagationAuthenticationWorkflow;
import com.amazon.athena.jdbc.authentication.utils.JwtTrustedIdentityProviderUtils;
import com.amazon.athena.jdbc.cache.Cache;
import com.amazon.athena.jdbc.cache.CacheManager;
import com.amazon.athena.jdbc.cache.TokenCacheEntry;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import com.amazon.athena.jdbc.support.EndpointHelper;
import com.amazon.athena.jdbc.support.ProxyHelper;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;

public class JwtTrustedIdentityPropagationCredentialsProviderFactory
implements CredentialsProviderFactory {
    private static final int DEFAULT_ROLE_SESSION_DURATION = 3600;
    private static final List<ConnectionParameter<?>> REQUIRED_PARAMETERS = Arrays.asList(ConnectionParameters.APPLICATION_ROLE_ARN_PARAMETER, ConnectionParameters.WORKGROUP_ARN_PARAMETER, ConnectionParameters.JWT_WEB_IDENTITY_TOKEN_PARAMETER, ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER);
    private final Cache<TokenCacheEntry> idcTokenCache;

    public JwtTrustedIdentityPropagationCredentialsProviderFactory(CacheManager cacheManager) {
        this.idcTokenCache = cacheManager.getCache(TokenCacheEntry.class);
    }

    @Override
    public String name() {
        return "JWT_TIP";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        this.validateParameters(parameters);
        String webIdentityToken = ConnectionParameters.JWT_WEB_IDENTITY_TOKEN_PARAMETER.findValue(parameters).get();
        ProxyConfiguration proxyConfiguration = ProxyHelper.getSyncProxyConfiguration(parameters).orElse(null);
        JwtTrustedIdentityProviderUtils jwtTrustedIdentityProviderUtils = this.createJwtTrustedIdentityProviderUtils(parameters, proxyConfiguration);
        TrustedIdentityPropagationAuthenticationWorkflow trustedIdentityPropagationAuthenticationWorkflow = this.createTrustedIdentityPropagationAuthenticationWorkflow(parameters, jwtTrustedIdentityProviderUtils);
        return new JwtTrustedIdentityPropagationCredentialsProvider(webIdentityToken, trustedIdentityPropagationAuthenticationWorkflow);
    }

    private JwtTrustedIdentityProviderUtils createJwtTrustedIdentityProviderUtils(Map<ConnectionParameter<?>, String> parameters, ProxyConfiguration proxyConfiguration) {
        Region region = ConnectionParameters.REGION_PARAMETER.findValue(parameters).orElse(null);
        URI stsEndpoint = ConnectionParameters.STS_ENDPOINT_PARAMETER.findValue(parameters).map(endpoint -> EndpointHelper.constructEndpointUri(endpoint, "STS")).orElse(null);
        URI ssoOidcEndpoint = ConnectionParameters.SSO_OIDC_ENDPOINT_PARAMETER.findValue(parameters).map(endpoint -> EndpointHelper.constructEndpointUri(endpoint, "SSO OIDC")).orElse(null);
        URI ssoAdminEndpoint = ConnectionParameters.SSO_ADMIN_ENDPOINT_PARAMETER.findValue(parameters).map(endpoint -> EndpointHelper.constructEndpointUri(endpoint, "SSO Admin")).orElse(null);
        Optional<String> host = ConnectionParameters.HOST.findValue(parameters);
        Optional<String> athenaEndpoint = ConnectionParameters.ATHENA_ENDPOINT_PARAMETER.findValue(parameters);
        return new JwtTrustedIdentityProviderUtils(region, stsEndpoint, proxyConfiguration, host, athenaEndpoint, ssoOidcEndpoint, ssoAdminEndpoint);
    }

    private TrustedIdentityPropagationAuthenticationWorkflow createTrustedIdentityPropagationAuthenticationWorkflow(Map<ConnectionParameter<?>, String> parameters, JwtTrustedIdentityProviderUtils jwtTrustedIdentityProviderUtils) {
        String applicationRoleArn = ConnectionParameters.APPLICATION_ROLE_ARN_PARAMETER.findValue(parameters).get();
        String workgroupArn = ConnectionParameters.WORKGROUP_ARN_PARAMETER.findValue(parameters).get();
        String customerIdcApplicationArn = ConnectionParameters.CUSTOMER_IDC_APPLICATION_ARN.findValue(parameters).orElse(null);
        String accessRoleArn = ConnectionParameters.ACCESS_ROLE_ARN_PARAMETER.findValue(parameters).orElse(null);
        String roleSessionName = ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER.findValue(parameters).get();
        Integer roleSessionDuration = ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.findValue(parameters).orElse(3600);
        return new TrustedIdentityPropagationAuthenticationWorkflow(applicationRoleArn, workgroupArn, customerIdcApplicationArn, accessRoleArn, roleSessionName, roleSessionDuration, jwtTrustedIdentityProviderUtils, this.idcTokenCache);
    }

    private void validateParameters(Map<ConnectionParameter<?>, String> parameters) {
        String errorMessage = REQUIRED_PARAMETERS.stream().filter(parameter -> !parameter.findValue(parameters).isPresent()).map(missingParameter -> String.format("The %s parameter must be specified when using the %s credentials provider", missingParameter.name(), this.name())).collect(Collectors.joining("; "));
        if (!errorMessage.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.REGION_PARAMETER, ConnectionParameters.JWT_WEB_IDENTITY_TOKEN_PARAMETER, ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER, ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER, ConnectionParameters.ACCESS_ROLE_ARN_PARAMETER, ConnectionParameters.CUSTOMER_IDC_APPLICATION_ARN, ConnectionParameters.APPLICATION_ROLE_ARN_PARAMETER, ConnectionParameters.WORKGROUP_ARN_PARAMETER);
    }
}

