/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.cache;

import com.amazon.athena.jdbc.cache.CacheEntry;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;
import lombok.NonNull;

public class JwtTokenCacheEntry
implements CacheEntry {
    @NonNull
    private final String idToken;
    @NonNull
    private final Instant expiration;
    private final String accessToken;
    private final String refreshToken;
    private final String scope;
    private final String tokenType;

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isExpired(Duration threshold) {
        return Instant.now().plus(threshold).isAfter(this.getExpiration());
    }

    @Generated
    JwtTokenCacheEntry(@NonNull String idToken, @NonNull Instant expiration, String accessToken, String refreshToken, String scope, String tokenType) {
        if (idToken == null) {
            throw new NullPointerException("idToken is marked non-null but is null");
        }
        if (expiration == null) {
            throw new NullPointerException("expiration is marked non-null but is null");
        }
        this.idToken = idToken;
        this.expiration = expiration;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.scope = scope;
        this.tokenType = tokenType;
    }

    @Generated
    public static JwtTokenCacheEntryBuilder builder() {
        return new JwtTokenCacheEntryBuilder();
    }

    @NonNull
    @Generated
    public String getIdToken() {
        return this.idToken;
    }

    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Generated
    public String getScope() {
        return this.scope;
    }

    @Generated
    public String getTokenType() {
        return this.tokenType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtTokenCacheEntry)) {
            return false;
        }
        JwtTokenCacheEntry other = (JwtTokenCacheEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$idToken = this.getIdToken();
        String other$idToken = other.getIdToken();
        if (this$idToken == null ? other$idToken != null : !this$idToken.equals(other$idToken)) {
            return false;
        }
        Instant this$expiration = this.getExpiration();
        Instant other$expiration = other.getExpiration();
        if (this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        return !(this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JwtTokenCacheEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $idToken = this.getIdToken();
        result = result * 59 + ($idToken == null ? 43 : $idToken.hashCode());
        Instant $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JwtTokenCacheEntry(idToken=" + this.getIdToken() + ", expiration=" + this.getExpiration() + ", accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", scope=" + this.getScope() + ", tokenType=" + this.getTokenType() + ")";
    }

    @Generated
    public static class JwtTokenCacheEntryBuilder {
        @Generated
        private String idToken;
        @Generated
        private Instant expiration;
        @Generated
        private String accessToken;
        @Generated
        private String refreshToken;
        @Generated
        private String scope;
        @Generated
        private String tokenType;

        @Generated
        JwtTokenCacheEntryBuilder() {
        }

        @Generated
        public JwtTokenCacheEntryBuilder idToken(@NonNull String idToken) {
            if (idToken == null) {
                throw new NullPointerException("idToken is marked non-null but is null");
            }
            this.idToken = idToken;
            return this;
        }

        @Generated
        public JwtTokenCacheEntryBuilder expiration(@NonNull Instant expiration) {
            if (expiration == null) {
                throw new NullPointerException("expiration is marked non-null but is null");
            }
            this.expiration = expiration;
            return this;
        }

        @Generated
        public JwtTokenCacheEntryBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Generated
        public JwtTokenCacheEntryBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Generated
        public JwtTokenCacheEntryBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public JwtTokenCacheEntryBuilder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @Generated
        public JwtTokenCacheEntry build() {
            return new JwtTokenCacheEntry(this.idToken, this.expiration, this.accessToken, this.refreshToken, this.scope, this.tokenType);
        }

        @Generated
        public String toString() {
            return "JwtTokenCacheEntry.JwtTokenCacheEntryBuilder(idToken=" + this.idToken + ", expiration=" + this.expiration + ", accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", scope=" + this.scope + ", tokenType=" + this.tokenType + ")";
        }
    }
}

