/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.results;

import com.amazon.athena.jdbc.AthenaDataType;
import com.amazon.athena.jdbc.configuration.ConnectionConfiguration;
import com.amazon.athena.jdbc.results.ExtendedDatabase;
import com.amazon.athena.jdbc.results.IteratorResultSetBase;
import com.amazon.athena.jdbc.results.ListDataCatalogsResultSet;
import com.amazon.athena.jdbc.support.LikePatternHelper;
import com.amazon.athena.jdbc.support.PaginatingIteratorBase;
import com.amazon.athena.logging.AthenaLogger;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.model.DataCatalogSummary;
import software.amazon.awssdk.services.athena.model.Database;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.utils.Pair;

public class ListDatabasesResultSet
extends IteratorResultSetBase<ExtendedDatabase> {
    private static final AthenaLogger logger = AthenaLogger.of(ListDatabasesResultSet.class);
    private static final String SCHEMATA_TABLE_NAME = "SCHEMATA";
    private static final String SCHEMA_COLUMN_NAME = "TABLE_SCHEM";
    private static final String CATALOG_COLUMN_NAME = "TABLE_CATALOG";
    private static final ResultSetMetadata META_DATA = (ResultSetMetadata)ResultSetMetadata.builder().columnInfo((ColumnInfo)ColumnInfo.builder().label("TABLE_SCHEM").name("TABLE_SCHEM").type(AthenaDataType.VARCHAR.athenaName()).tableName("SCHEMATA").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(128).scale(0).caseSensitive(false).nullable(ColumnNullable.NOT_NULL).build(), (ColumnInfo)ColumnInfo.builder().label("TABLE_CATALOG").name("TABLE_CATALOG").type(AthenaDataType.VARCHAR.athenaName()).tableName("SCHEMATA").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(256).scale(0).caseSensitive(false).nullable(ColumnNullable.NOT_NULL).build()).build();
    private final ConnectionConfiguration configuration;
    private final String catalogName;
    private final String schemaNamePattern;
    private final Iterator<DataCatalogSummary> catalogIterator;

    public ListDatabasesResultSet(ConnectionConfiguration configuration, String catalogName, String schemaNamePattern) {
        super(META_DATA);
        this.configuration = configuration;
        this.catalogName = LikePatternHelper.unescapeWildcards(catalogName);
        this.schemaNamePattern = schemaNamePattern;
        this.catalogIterator = new ListDataCatalogsResultSet(configuration).iterator();
    }

    @Override
    protected Iterator<ExtendedDatabase> iterator() {
        if (!(this.catalogName != null && this.catalogName.length() <= 0 || this.schemaNamePattern != null && this.schemaNamePattern.length() <= 0)) {
            return new DatabaseIterator(this.catalogIterator, this.configuration.getAthenaSdkClient(), this.configuration.getApiRequestTimeout(), this.configuration.getWorkGroup(), this.catalogName, this.schemaNamePattern);
        }
        return Collections.emptyIterator();
    }

    @Override
    protected String stringValue(ExtendedDatabase currentRow, int columnIndex) {
        if (columnIndex == 1) {
            return currentRow.getSchemaName();
        }
        return currentRow.getCatalogName();
    }

    private static class DatabaseIterator
    extends PaginatingIteratorBase<ExtendedDatabase> {
        private final AthenaAsyncClient athenaClient;
        private final String workGroup;
        private final String catalogName;
        private final String schemaNamePattern;
        private final Iterator<DataCatalogSummary> catalogIterator;
        private String currentCatalogName;

        DatabaseIterator(Iterator<DataCatalogSummary> catalogIterator, AthenaAsyncClient athenaClient, Duration requestTimeout, String workGroup, String catalogName, String schemaNamePattern) {
            super(requestTimeout);
            this.athenaClient = athenaClient;
            this.workGroup = workGroup;
            this.catalogName = catalogName;
            this.schemaNamePattern = schemaNamePattern;
            this.catalogIterator = catalogIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.catalogName == null) {
                while ((this.currentPage == null || this.currentPage.isEmpty()) && this.catalogIterator.hasNext()) {
                    this.currentCatalogName = this.catalogIterator.next().catalogName();
                    this.loadNextPage();
                }
                if (!this.exhausted && this.currentPage != null && this.currentIndex + 1 >= this.currentPage.size()) {
                    this.loadNextPage();
                } else if (this.pageIsExhausted() && this.catalogIterator.hasNext()) {
                    this.currentCatalogName = this.catalogIterator.next().catalogName();
                    this.loadNextPage();
                }
            } else {
                this.currentCatalogName = this.catalogName;
                if (!(this.exhausted || this.currentPage != null && this.currentIndex + 1 < this.currentPage.size())) {
                    this.loadNextPage();
                }
            }
            return !this.pageIsExhausted();
        }

        private boolean pageIsExhausted() {
            return this.currentPage == null || this.exhausted && this.currentIndex + 1 >= this.currentPage.size();
        }

        @Override
        protected CompletableFuture<Pair<List<ExtendedDatabase>, Optional<String>>> loadNextPage(Optional<String> nextToken) {
            ListDatabasesRequest request = (ListDatabasesRequest)ListDatabasesRequest.builder().workGroup(this.workGroup).catalogName(this.currentCatalogName).nextToken(nextToken.orElse(null)).build();
            logger.debug("Listing databases", new Object[0]);
            logger.trace("Sending ListDatabases request: {}", request);
            return ((CompletableFuture)this.athenaClient.listDatabases(request).whenComplete((response, error) -> {
                if (error != null) {
                    logger.warn(String.format("Could not list databases: %s", error.getMessage()), (Throwable)error);
                }
            })).thenApply(response -> {
                logger.trace("Listing databases succeeded, got {} database(s) before filtering with the database name pattern \"{}\"", response.databaseList().size(), this.schemaNamePattern);
                List<Database> databases = this.dbsFilteredByNamePattern((ListDatabasesResponse)response);
                List<ExtendedDatabase> extendedDatabases = this.mapDatabasesToExtendedDatabases(databases);
                logger.info("Listing databases succeeded, got {} database(s)", extendedDatabases.size());
                return Pair.of(extendedDatabases, Optional.ofNullable(response.nextToken()));
            });
        }

        private List<ExtendedDatabase> mapDatabasesToExtendedDatabases(List<Database> response) {
            return response.stream().map(database -> new ExtendedDatabase(this.currentCatalogName, database.name())).collect(Collectors.toList());
        }

        private List<Database> dbsFilteredByNamePattern(ListDatabasesResponse response) {
            return response.databaseList().stream().filter(db -> LikePatternHelper.matches(this.schemaNamePattern, db.name())).collect(Collectors.toList());
        }
    }
}

