/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.results;

import com.amazon.athena.jdbc.AthenaDataType;
import com.amazon.athena.jdbc.configuration.ConnectionConfiguration;
import com.amazon.athena.jdbc.results.ExtendedDatabase;
import com.amazon.athena.jdbc.results.ExtendedTableMetadata;
import com.amazon.athena.jdbc.results.IteratorResultSetBase;
import com.amazon.athena.jdbc.results.ListDatabasesResultSet;
import com.amazon.athena.jdbc.support.LikePatternHelper;
import com.amazon.athena.jdbc.support.PaginatingIteratorBase;
import com.amazon.athena.logging.AthenaLogger;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.model.GetTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.services.athena.model.TableMetadata;
import software.amazon.awssdk.utils.Pair;

public class ListTableMetadataResultSet
extends IteratorResultSetBase<ExtendedTableMetadata> {
    private static final AthenaLogger logger = AthenaLogger.of(ListTableMetadataResultSet.class);
    private static final String TABLES_TABLE_NAME = "TABLES";
    private static final String CATALOG_COLUMN_NAME = "TABLE_CAT";
    private static final String SCHEMA_COLUMN_NAME = "TABLE_SCHEM";
    private static final String NAME_COLUMN_NAME = "TABLE_NAME";
    private static final String TYPE_COLUMN_NAME = "TABLE_TYPE";
    private static final String REMARKS_COLUMN_NAME = "REMARKS";
    private static final String TYPES_CATALOG_COLUMN_NAME = "TYPE_CAT";
    private static final String TYPES_SCHEMA_COLUMN_NAME = "TYPE_SCHEM";
    private static final String TYPE_NAME_COLUMN_NAME = "TYPE_NAME";
    private static final String SELF_REFERENCING_COLUMN_NAME_COLUMN_NAME = "SELF_REFERENCING_COL_NAME";
    private static final String REFERENCE_GENERATION_COLUMN_NAME = "REF_GENERATION";
    private static final String ATHENA_VIRTUAL_VIEW_TYPE = "VIRTUAL_VIEW";
    private static final ResultSetMetadata META_DATA = (ResultSetMetadata)ResultSetMetadata.builder().columnInfo((ColumnInfo)ColumnInfo.builder().label("TABLE_CAT").name("TABLE_CAT").type(AthenaDataType.VARCHAR.athenaName()).tableName("TABLES").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(256).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("TABLE_SCHEM").name("TABLE_SCHEM").type(AthenaDataType.VARCHAR.athenaName()).tableName("TABLES").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(128).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("TABLE_NAME").name("TABLE_NAME").type(AthenaDataType.VARCHAR.athenaName()).tableName("TABLES").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(128).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("TABLE_TYPE").name("TABLE_TYPE").type(AthenaDataType.VARCHAR.athenaName()).tableName("TABLES").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(5).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("REMARKS").name("REMARKS").type(AthenaDataType.VARCHAR.athenaName()).tableName("TABLES").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NOT_NULL).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("TYPE_CAT").name("TYPE_CAT").type(AthenaDataType.VARCHAR.athenaName()).tableName("TABLES").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("TYPE_SCHEM").name("TYPE_SCHEM").type(AthenaDataType.VARCHAR.athenaName()).tableName("TABLES").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("TYPE_NAME").name("TYPE_NAME").type(AthenaDataType.VARCHAR.athenaName()).tableName("TABLES").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("SELF_REFERENCING_COL_NAME").name("SELF_REFERENCING_COL_NAME").type(AthenaDataType.VARCHAR.athenaName()).tableName("TABLES").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NULLABLE).caseSensitive(false).build(), (ColumnInfo)ColumnInfo.builder().label("REF_GENERATION").name("REF_GENERATION").type(AthenaDataType.VARCHAR.athenaName()).tableName("TABLES").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(0).scale(0).nullable(ColumnNullable.NULLABLE).build()).build();
    private static final int CATALOG_COLUMN_INDEX = 1;
    private static final int SCHEMA_COLUMN_INDEX = 2;
    private static final int NAME_COLUMN_INDEX = 3;
    private static final int TYPE_COLUMN_INDEX = 4;
    private static final int REMARKS_COLUMN_INDEX = 5;
    private final ConnectionConfiguration configuration;
    private final String catalogName;
    private final String schemaNamePattern;
    private final String tableName;
    private final TableTypeFilter tableTypes;
    private final Iterator<ExtendedDatabase> databaseIterator;

    public ListTableMetadataResultSet(ConnectionConfiguration configuration, String catalogName, String schemaNamePattern, String tableNamePattern, String[] tableTypes) {
        super(META_DATA);
        this.configuration = configuration;
        this.catalogName = LikePatternHelper.unescapeWildcards(catalogName);
        this.schemaNamePattern = LikePatternHelper.unescapeWildcards(schemaNamePattern);
        this.tableName = tableNamePattern;
        this.tableTypes = this.toTableTypeFilter(tableTypes);
        this.databaseIterator = this.isWildcardCatalogOrSchema(catalogName, schemaNamePattern) ? new ListDatabasesResultSet(configuration, catalogName, schemaNamePattern).iterator() : Collections.singleton(new ExtendedDatabase(LikePatternHelper.unescapeWildcards(catalogName), LikePatternHelper.unescapeWildcards(schemaNamePattern))).iterator();
    }

    private boolean isWildcardCatalogOrSchema(String catalogName, String schemaNamePattern) {
        return catalogName == null || schemaNamePattern == null || LikePatternHelper.containsWildcards(schemaNamePattern);
    }

    private TableTypeFilter toTableTypeFilter(String[] tableTypes) {
        boolean includeTables = false;
        boolean includeViews = false;
        if (tableTypes == null) {
            includeTables = true;
            includeViews = true;
        } else {
            for (String tableType : tableTypes) {
                if (tableType.equals("TABLE")) {
                    includeTables = true;
                    continue;
                }
                if (tableType.equals("VIEW")) {
                    includeViews = true;
                    continue;
                }
                throw new IllegalArgumentException(String.format("Unrecognized table type: \"%s\"", tableType));
            }
        }
        if (includeTables && includeViews) {
            return TableTypeFilter.ALL;
        }
        if (includeTables) {
            return TableTypeFilter.ONLY_TABLES;
        }
        if (includeViews) {
            return TableTypeFilter.ONLY_VIEWS;
        }
        return TableTypeFilter.NONE;
    }

    @Override
    public Iterator<ExtendedTableMetadata> iterator() {
        if (!(this.catalogName != null && this.catalogName.length() <= 0 || this.schemaNamePattern != null && this.schemaNamePattern.length() <= 0 || this.tableName != null && this.tableName.length() <= 0 || this.tableTypes == TableTypeFilter.NONE)) {
            return new TableMetadataIterator(this.databaseIterator, this.configuration.getAthenaSdkClient(), this.configuration.getApiRequestTimeout(), this.configuration.getWorkGroup(), this.tableName, this.tableTypes);
        }
        return Collections.emptyIterator();
    }

    @Override
    protected String stringValue(ExtendedTableMetadata currentRow, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return currentRow.getCatalogName();
            }
            case 2: {
                return currentRow.getSchemaName();
            }
            case 3: {
                return currentRow.getTableName();
            }
            case 4: {
                return ATHENA_VIRTUAL_VIEW_TYPE.equalsIgnoreCase(currentRow.getTableType()) ? "VIEW" : "TABLE";
            }
            case 5: {
                return "";
            }
        }
        return null;
    }

    public static class TableMetadataIterator
    extends PaginatingIteratorBase<ExtendedTableMetadata> {
        private final AthenaAsyncClient athenaClient;
        private final String workGroup;
        private final String tableNamePattern;
        private final TableTypeFilter tableTypes;
        private final Iterator<ExtendedDatabase> databaseIterator;
        private final String expression;
        private final Pattern tablePattern;
        private String currentDbName;
        private String currentCatalogName;

        TableMetadataIterator(Iterator<ExtendedDatabase> databaseIterator, AthenaAsyncClient athenaClient, Duration requestTimeout, String workGroup, String tableNamePattern, TableTypeFilter tableTypes) {
            super(requestTimeout);
            this.athenaClient = athenaClient;
            this.workGroup = workGroup;
            this.tableNamePattern = tableNamePattern;
            this.tableTypes = tableTypes;
            this.databaseIterator = databaseIterator;
            this.expression = LikePatternHelper.toPatternString(tableNamePattern);
            this.tablePattern = Pattern.compile(this.expression);
        }

        @Override
        public boolean hasNext() {
            ExtendedDatabase extendedDatabase;
            while ((this.currentPage == null || this.currentPage.isEmpty()) && this.databaseIterator.hasNext()) {
                extendedDatabase = this.databaseIterator.next();
                this.currentCatalogName = extendedDatabase.getCatalogName();
                this.currentDbName = extendedDatabase.getSchemaName();
                this.loadNextPage();
            }
            if (!this.exhausted && this.currentPage != null && this.currentIndex + 1 >= this.currentPage.size()) {
                this.loadNextPage();
            } else if (this.pageIsExhausted() && this.databaseIterator.hasNext()) {
                extendedDatabase = this.databaseIterator.next();
                this.currentCatalogName = extendedDatabase.getCatalogName();
                this.currentDbName = extendedDatabase.getSchemaName();
                this.loadNextPage();
            }
            return !this.pageIsExhausted();
        }

        private boolean pageIsExhausted() {
            return this.currentPage == null || this.exhausted && this.currentIndex + 1 >= this.currentPage.size();
        }

        @Override
        protected CompletableFuture<Pair<List<ExtendedTableMetadata>, Optional<String>>> loadNextPage(Optional<String> nextToken) {
            if (this.tableNamePattern != null && !LikePatternHelper.containsWildcards(this.tableNamePattern) && !nextToken.isPresent()) {
                return this.loadSingleTableMetadata();
            }
            return this.loadMultipleTablesMetadata(nextToken);
        }

        private CompletableFuture<Pair<List<ExtendedTableMetadata>, Optional<String>>> loadSingleTableMetadata() {
            GetTableMetadataRequest request = (GetTableMetadataRequest)GetTableMetadataRequest.builder().workGroup(this.workGroup).catalogName(this.currentCatalogName).databaseName(this.currentDbName).tableName(this.expression).build();
            logger.debug("Listing tables (without wildcards)", new Object[0]);
            logger.trace("Sending GetTableMetadata request: {}", request);
            return this.athenaClient.getTableMetadata(request).handle((response, error) -> {
                if (error != null) {
                    if (TableMetadataIterator.isTableNotFound(error)) {
                        logger.info("Listing tables succeeded, got 0 tables as the requested table does not exist", new Object[0]);
                        return Pair.of(Collections.emptyList(), Optional.empty());
                    }
                    logger.warn(String.format("Could not list tables: %s", error.getMessage()), (Throwable)error);
                    if (error instanceof CompletionException) {
                        throw (CompletionException)error;
                    }
                    throw new CompletionException((Throwable)error);
                }
                logger.trace("Listing tables succeeded, got table \"{}\" before filtering by the table types {}", new Object[]{response.tableMetadata().name(), this.tableTypes});
                List<TableMetadata> filteredTables = this.filterTablesByType(Collections.singletonList(response.tableMetadata()));
                List<ExtendedTableMetadata> extendedTableMetadata = this.mapMetadataToExtendedTableMetadata(filteredTables);
                logger.info("Listing tables succeeded, got {} table(s) (at most one expected)", extendedTableMetadata.size());
                return Pair.of(extendedTableMetadata, Optional.empty());
            });
        }

        private static boolean isTableNotFound(Throwable error) {
            return error.getMessage().contains("Entity Not Found") || error.getMessage().contains("No such table");
        }

        private CompletableFuture<Pair<List<ExtendedTableMetadata>, Optional<String>>> loadMultipleTablesMetadata(Optional<String> nextToken) {
            ListTableMetadataRequest request = (ListTableMetadataRequest)ListTableMetadataRequest.builder().workGroup(this.workGroup).catalogName(this.currentCatalogName).databaseName(this.currentDbName).expression(this.expression).nextToken(nextToken.orElse(null)).build();
            logger.debug("Listing tables", new Object[0]);
            logger.trace("Sending ListTableMetadata request: {}", request);
            return ((CompletableFuture)this.athenaClient.listTableMetadata(request).whenComplete((response, error) -> {
                if (error != null) {
                    logger.warn(String.format("Could not list tables: %s", error.getMessage()), (Throwable)error);
                }
            })).thenApply(response -> {
                logger.trace("Listing tables succeeded, got \"{}\" table(s) before filtering by the table name pattern \"{}\" and the table types {}", new Object[]{response.tableMetadataList().size(), this.tableNamePattern, this.tableTypes});
                List<TableMetadata> filteredTablesByName = this.filterTablesByName(response.tableMetadataList());
                List<TableMetadata> filteredTablesByNameAndType = this.filterTablesByType(filteredTablesByName);
                List<ExtendedTableMetadata> extendedTableMetadata = this.mapMetadataToExtendedTableMetadata(filteredTablesByNameAndType);
                logger.info("Listing tables succeeded, got {} table(s)", extendedTableMetadata.size());
                return Pair.of(extendedTableMetadata, Optional.ofNullable(response.nextToken()));
            });
        }

        private List<ExtendedTableMetadata> mapMetadataToExtendedTableMetadata(List<TableMetadata> filteredTables) {
            return filteredTables.stream().map(metadata -> new ExtendedTableMetadata((TableMetadata)metadata, this.currentCatalogName, this.currentDbName)).collect(Collectors.toList());
        }

        private boolean isView(TableMetadata table) {
            return ListTableMetadataResultSet.ATHENA_VIRTUAL_VIEW_TYPE.equals(table.tableType());
        }

        private List<TableMetadata> filterTablesByType(List<TableMetadata> tables) {
            if (this.tableTypes == TableTypeFilter.ONLY_TABLES) {
                return tables.stream().filter(((Predicate<TableMetadata>)this::isView).negate()).collect(Collectors.toList());
            }
            if (this.tableTypes == TableTypeFilter.ONLY_VIEWS) {
                return tables.stream().filter(this::isView).collect(Collectors.toList());
            }
            return tables;
        }

        private List<TableMetadata> filterTablesByName(List<TableMetadata> tables) {
            return tables.stream().filter(table -> this.tablePattern.matcher(table.name()).matches()).collect(Collectors.toList());
        }
    }

    private static enum TableTypeFilter {
        ALL,
        ONLY_TABLES,
        ONLY_VIEWS,
        NONE;

    }
}

