/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class LikePatternHelper {
    private static final Set<Character> REGEX_SPECIAL_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('<'), Character.valueOf('('), Character.valueOf('['), Character.valueOf('{'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('-'), Character.valueOf('='), Character.valueOf('$'), Character.valueOf('!'), Character.valueOf('|'), Character.valueOf(']'), Character.valueOf('}'), Character.valueOf(')'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('>')));

    public static String unescapeWildcards(String likePattern) {
        if (likePattern == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean isEscape = false;
        for (int i = 0; i < likePattern.length(); ++i) {
            char c = likePattern.charAt(i);
            if (c == '\\' && !isEscape) {
                isEscape = true;
                continue;
            }
            if ((c == '%' || c == '_') && isEscape) {
                builder.append(c);
                isEscape = false;
                continue;
            }
            if (isEscape) {
                builder.append('\\').append(c);
                isEscape = false;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static boolean containsWildcards(String likePattern) {
        if (likePattern == null) {
            return false;
        }
        boolean isEscape = false;
        for (int i = 0; i < likePattern.length(); ++i) {
            char c = likePattern.charAt(i);
            if (c == '\\') {
                isEscape = !isEscape;
                continue;
            }
            if (!(c != '%' && c != '_' || isEscape)) {
                return true;
            }
            isEscape = false;
        }
        return false;
    }

    public static boolean matches(String pattern, String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input value is required.");
        }
        return Pattern.matches(LikePatternHelper.toPatternString(pattern), input);
    }

    public static String toPatternString(String likePattern) {
        if (likePattern == null) {
            return ".*";
        }
        StringBuilder regexPattern = new StringBuilder();
        boolean isEscape = false;
        for (int i = 0; i < likePattern.length(); ++i) {
            char c = likePattern.charAt(i);
            if (c == '\\' && !isEscape) {
                isEscape = true;
                continue;
            }
            if (c == '%' || c == '_') {
                if (isEscape) {
                    regexPattern.append(c);
                    isEscape = false;
                    continue;
                }
                regexPattern.append('.');
                if (c != '%') continue;
                regexPattern.append('*');
                continue;
            }
            if (REGEX_SPECIAL_CHARS.contains(Character.valueOf(c)) || isEscape) {
                regexPattern.append('\\').append(c);
                isEscape = false;
                continue;
            }
            regexPattern.append(c);
        }
        if (isEscape) {
            regexPattern.append('\\');
        }
        return regexPattern.toString();
    }
}

