/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.Token;
import com.amazon.athena.jdbc.support.sql.TokenType;
import com.amazon.athena.jdbc.support.sql.WrongNumberOfArgumentsException;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

class JdbcFunction {
    protected final int minExpectedArgs;
    protected final int maxExpectedArgs;
    protected final String jdbcName;
    protected final String athenaName;
    private final FunctionCategory category;

    JdbcFunction(String name, FunctionCategory category, int expectedArgs) {
        this(name, name, category, expectedArgs, expectedArgs);
    }

    JdbcFunction(String jdbcName, String athenaName, FunctionCategory category, int minExpectedArgs, int maxExpectedArgs) {
        this.jdbcName = jdbcName;
        this.athenaName = athenaName;
        this.minExpectedArgs = minExpectedArgs;
        this.maxExpectedArgs = maxExpectedArgs;
        this.category = category;
    }

    boolean isOperator() {
        return false;
    }

    protected boolean hasExpression(List<Token> argumentTokens) {
        return this.findFirstExpression(argumentTokens).isPresent();
    }

    protected Optional<Token> findFirstExpression(List<Token> argumentTokens) {
        for (Token argumentToken : argumentTokens) {
            if (argumentToken.type() != TokenType.SQL) continue;
            return Optional.of(argumentToken);
        }
        return Optional.empty();
    }

    protected List<Token> trimWhitespacePrefix(Deque<Token> argument) {
        LinkedList<Token> whitespace = new LinkedList<Token>();
        while (!argument.isEmpty() && argument.peekFirst().isWhitespace()) {
            whitespace.add(argument.removeFirst());
        }
        return whitespace;
    }

    protected List<Token> trimWhitespaceSuffix(Deque<Token> argument) {
        LinkedList<Token> whitespace = new LinkedList<Token>();
        while (!argument.isEmpty() && argument.peekLast().isWhitespace()) {
            whitespace.add(argument.removeLast());
        }
        return whitespace;
    }

    protected void trimWhitespace(Deque<Token> argument) {
        this.trimWhitespacePrefix(argument);
        this.trimWhitespaceSuffix(argument);
    }

    protected boolean hasWhitespaceSuffix(List<Token> argument) {
        return !argument.isEmpty() && argument.get(argument.size() - 1).isWhitespace();
    }

    protected List<Token> ensureHasWhitespacePrefix(List<Token> argument) {
        LinkedList<Token> newArgument = new LinkedList<Token>();
        if (!argument.isEmpty() && !argument.get(0).isWhitespace()) {
            newArgument.add(Token.space());
        }
        newArgument.addAll(argument);
        return newArgument;
    }

    protected List<Token> toCast(List<Token> rawArgument, String toType) {
        LinkedList<Token> arg = new LinkedList<Token>(rawArgument);
        List<Token> whitespacePrefix = this.trimWhitespacePrefix(arg);
        List<Token> whitespaceSuffix = this.trimWhitespaceSuffix(arg);
        LinkedList<Token> argWithCast = new LinkedList<Token>(whitespacePrefix);
        argWithCast.add(Token.sql("CAST("));
        argWithCast.addAll(arg);
        argWithCast.add(Token.space());
        argWithCast.add(Token.sql("AS"));
        argWithCast.add(Token.space());
        argWithCast.add(Token.sql(toType));
        argWithCast.add(Token.sql(")"));
        argWithCast.addAll(whitespaceSuffix);
        return argWithCast;
    }

    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        if (this.minExpectedArgs == 0 && rawArgs.size() == 1) {
            if (this.hasExpression(rawArgs.get(0))) {
                throw new WrongNumberOfArgumentsException(this.jdbcName, this.minExpectedArgs, rawArgs.size());
            }
        } else {
            if (this.minExpectedArgs == this.maxExpectedArgs && rawArgs.size() != this.minExpectedArgs) {
                throw new WrongNumberOfArgumentsException(this.jdbcName, this.minExpectedArgs, rawArgs.size());
            }
            if (rawArgs.size() < this.minExpectedArgs || rawArgs.size() > this.maxExpectedArgs) {
                throw new WrongNumberOfArgumentsException(this.jdbcName, this.minExpectedArgs, this.maxExpectedArgs, rawArgs.size());
            }
        }
        return rawArgs;
    }

    List<Token> processFunctionCall(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> processedArgs = this.processArguments(rawArgs);
        LinkedList<Token> functionTokens = new LinkedList<Token>();
        functionTokens.add(Token.sql(this.athenaName()));
        if (!this.isOperator()) {
            functionTokens.add(Token.sql("("));
            for (int i = 0; i < processedArgs.size(); ++i) {
                if (i > 0) {
                    functionTokens.add(Token.sql(","));
                }
                functionTokens.addAll((Collection<Token>)processedArgs.get(i));
            }
            functionTokens.add(Token.sql(")"));
        }
        return functionTokens;
    }

    @Generated
    public String jdbcName() {
        return this.jdbcName;
    }

    @Generated
    public String athenaName() {
        return this.athenaName;
    }

    @Generated
    public FunctionCategory category() {
        return this.category;
    }

    static enum FunctionCategory {
        NUMERIC,
        STRING,
        TIME_AND_DATE,
        CONVERSION,
        SYSTEM;

    }
}

