/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Immutable
@SdkPublicApi
public final class AwsBasicCredentials
implements AwsCredentials,
ToCopyableBuilder<Builder, AwsBasicCredentials> {
    @SdkInternalApi
    static final AwsBasicCredentials ANONYMOUS_CREDENTIALS = AwsBasicCredentials.builder().validateCredentials(false).build();
    private final String accessKeyId;
    private final String secretAccessKey;
    private final boolean validateCredentials;
    private final String providerName;
    private final String accountId;

    private AwsBasicCredentials(Builder builder) {
        this.accessKeyId = StringUtils.trimToNull(builder.accessKeyId);
        this.secretAccessKey = StringUtils.trimToNull(builder.secretAccessKey);
        this.validateCredentials = builder.validateCredentials;
        this.providerName = builder.providerName;
        this.accountId = builder.accountId;
        if (builder.validateCredentials) {
            Validate.notNull(this.accessKeyId, "Access key ID cannot be blank.", new Object[0]);
            Validate.notNull(this.secretAccessKey, "Secret access key cannot be blank.", new Object[0]);
        }
    }

    protected AwsBasicCredentials(String accessKeyId, String secretAccessKey) {
        this.accessKeyId = StringUtils.trimToNull(accessKeyId);
        this.secretAccessKey = StringUtils.trimToNull(secretAccessKey);
        this.validateCredentials = false;
        this.providerName = null;
        this.accountId = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AwsBasicCredentials create(String accessKeyId, String secretAccessKey) {
        return AwsBasicCredentials.builder().accessKeyId(accessKeyId).secretAccessKey(secretAccessKey).build();
    }

    @Override
    public String accessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    @Override
    public Optional<String> providerName() {
        return Optional.ofNullable(this.providerName);
    }

    @Override
    public Optional<String> accountId() {
        return Optional.ofNullable(this.accountId);
    }

    public String toString() {
        return ToString.builder("AwsCredentials").add("accessKeyId", this.accessKeyId).add("providerName", this.providerName).add("accountId", this.accountId).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsBasicCredentials that = (AwsBasicCredentials)o;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.secretAccessKey, that.secretAccessKey) && Objects.equals(this.accountId, that.accountId().orElse(null));
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId);
        return hashCode;
    }

    @Override
    public Builder toBuilder() {
        return AwsBasicCredentials.builder().accessKeyId(this.accessKeyId).secretAccessKey(this.secretAccessKey).accountId(this.accountId).validateCredentials(this.validateCredentials).providerName(this.providerName);
    }

    @Override
    public AwsBasicCredentials copy(Consumer<? super Builder> modifier) {
        return (AwsBasicCredentials)ToCopyableBuilder.super.copy(modifier);
    }

    public static final class Builder
    implements CopyableBuilder<Builder, AwsBasicCredentials> {
        private String accessKeyId;
        private String secretAccessKey;
        private String providerName;
        private String accountId;
        private boolean validateCredentials = true;

        private Builder() {
        }

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        @SdkInternalApi
        public Builder validateCredentials(Boolean validateCredentials) {
            this.validateCredentials = validateCredentials;
            return this;
        }

        @Override
        public AwsBasicCredentials build() {
            return new AwsBasicCredentials(this);
        }
    }
}

