/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.token.credentials.SdkToken;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.TokenIdentity;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkProtectedApi
public final class TokenUtils {
    private TokenUtils() {
    }

    public static SdkToken toSdkToken(TokenIdentity tokenIdentity) {
        if (tokenIdentity == null) {
            return null;
        }
        if (tokenIdentity instanceof SdkToken) {
            return (SdkToken)tokenIdentity;
        }
        return () -> tokenIdentity.token();
    }

    public static SdkTokenProvider toSdkTokenProvider(IdentityProvider<? extends TokenIdentity> identityProvider) {
        if (identityProvider == null) {
            return null;
        }
        if (identityProvider instanceof SdkTokenProvider) {
            return (SdkTokenProvider)identityProvider;
        }
        return () -> TokenUtils.toSdkToken((TokenIdentity)CompletableFutureUtils.joinLikeSync(identityProvider.resolveIdentity()));
    }
}

