/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.core.io.SdkFilterInputStream;
import software.amazon.awssdk.http.Abortable;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class ResponseInputStream<ResponseT>
extends SdkFilterInputStream
implements Abortable {
    private static final Logger log = Logger.loggerFor(ResponseInputStream.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(60L);
    private final ResponseT response;
    private final Abortable abortable;
    private ScheduledFuture<?> timeoutTask;
    private volatile boolean hasRead = false;

    public ResponseInputStream(ResponseT resp, AbortableInputStream in) {
        this(resp, in, null);
    }

    public ResponseInputStream(ResponseT resp, AbortableInputStream in, Duration timeout) {
        super(in);
        this.response = Validate.paramNotNull(resp, "response");
        this.abortable = Validate.paramNotNull(in, "abortableInputStream");
        Duration resolvedTimeout = timeout != null ? timeout : DEFAULT_TIMEOUT;
        this.scheduleTimeoutTask(resolvedTimeout);
    }

    public ResponseInputStream(ResponseT resp, InputStream in) {
        this(resp, in, null);
    }

    public ResponseInputStream(ResponseT resp, InputStream in, Duration timeout) {
        super(in);
        this.response = Validate.paramNotNull(resp, "response");
        this.abortable = in instanceof Abortable ? (Abortable)((Object)in) : null;
        Duration resolvedTimeout = timeout != null ? timeout : DEFAULT_TIMEOUT;
        this.scheduleTimeoutTask(resolvedTimeout);
    }

    public ResponseT response() {
        return this.response;
    }

    @Override
    public int read() throws IOException {
        this.cancelTimeoutTask();
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.cancelTimeoutTask();
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.cancelTimeoutTask();
        return super.read(b, off, len);
    }

    private void cancelTimeoutTask() {
        if (!this.hasRead && this.timeoutTask != null) {
            this.timeoutTask.cancel(false);
        }
        this.hasRead = true;
    }

    private void scheduleTimeoutTask(Duration timeout) {
        if (timeout.equals(Duration.ZERO) || timeout.isNegative()) {
            return;
        }
        long timeoutInMillis = timeout.toMillis();
        this.timeoutTask = TimeoutScheduler.INSTANCE.schedule(() -> {
            if (!this.hasRead) {
                log.debug(() -> String.format("InputStream was not read before timeout of [%d] milliseconds, aborting stream and closing connection.", timeoutInMillis));
                this.abort();
            }
        }, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void abort() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel(false);
        }
        if (this.abortable != null) {
            this.abortable.abort();
        }
        IoUtils.closeQuietlyV2(this.in, log);
    }

    @SdkTestInternalApi
    public boolean hasTimeoutTask() {
        return this.timeoutTask != null;
    }

    @SdkTestInternalApi
    public boolean timeoutTaskDoneOrCancelled() {
        return this.timeoutTask != null && this.timeoutTask.isDone();
    }

    private static final class TimeoutScheduler {
        static final ScheduledExecutorService INSTANCE = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r, "response-input-stream-timeout-scheduler");
            t.setDaemon(true);
            return t;
        });

        private TimeoutScheduler() {
        }
    }
}

