/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.checksums;

import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculation;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.utils.OptionalUtils;

@SdkProtectedApi
public final class RequestChecksumCalculationResolver {
    private static final RequestChecksumCalculation SDK_DEFAULT_CHECKSUM_CALCULATION = RequestChecksumCalculation.WHEN_SUPPORTED;
    private Supplier<ProfileFile> profileFile;
    private String profileName;
    private RequestChecksumCalculation defaultChecksumCalculation;

    private RequestChecksumCalculationResolver() {
    }

    public static RequestChecksumCalculationResolver create() {
        return new RequestChecksumCalculationResolver();
    }

    public RequestChecksumCalculationResolver profileFile(Supplier<ProfileFile> profileFile) {
        this.profileFile = profileFile;
        return this;
    }

    public RequestChecksumCalculationResolver profileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    public RequestChecksumCalculationResolver defaultChecksumCalculation(RequestChecksumCalculation defaultChecksumCalculation) {
        this.defaultChecksumCalculation = defaultChecksumCalculation;
        return this;
    }

    public RequestChecksumCalculation resolve() {
        return OptionalUtils.firstPresent(this.fromSystemSettings(), new Supplier[]{() -> this.fromProfileFile(this.profileFile, this.profileName)}).orElseGet(this::fromDefaultChecksumCalculation);
    }

    private Optional<RequestChecksumCalculation> fromSystemSettings() {
        return SdkSystemSetting.AWS_REQUEST_CHECKSUM_CALCULATION.getStringValue().flatMap(this::stringToEnum);
    }

    private Optional<RequestChecksumCalculation> fromProfileFile(Supplier<ProfileFile> profileFile, String profileName) {
        return profileFile.get().profile(profileName).flatMap(p -> p.property("request_checksum_calculation")).flatMap(this::stringToEnum);
    }

    private RequestChecksumCalculation fromDefaultChecksumCalculation() {
        return this.defaultChecksumCalculation != null ? this.defaultChecksumCalculation : SDK_DEFAULT_CHECKSUM_CALCULATION;
    }

    private Optional<RequestChecksumCalculation> stringToEnum(String value) {
        return Optional.of(RequestChecksumCalculation.fromValue(value));
    }
}

