/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.checksums;

import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.utils.OptionalUtils;

@SdkProtectedApi
public final class ResponseChecksumValidationResolver {
    private static final ResponseChecksumValidation SDK_DEFAULT_CHECKSUM_VALIDATION = ResponseChecksumValidation.WHEN_SUPPORTED;
    private Supplier<ProfileFile> profileFile;
    private String profileName;
    private ResponseChecksumValidation defaultChecksumValidation;

    private ResponseChecksumValidationResolver() {
    }

    public static ResponseChecksumValidationResolver create() {
        return new ResponseChecksumValidationResolver();
    }

    public ResponseChecksumValidationResolver profileFile(Supplier<ProfileFile> profileFile) {
        this.profileFile = profileFile;
        return this;
    }

    public ResponseChecksumValidationResolver profileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    public ResponseChecksumValidationResolver defaultChecksumValidation(ResponseChecksumValidation defaultChecksumValidation) {
        this.defaultChecksumValidation = defaultChecksumValidation;
        return this;
    }

    public ResponseChecksumValidation resolve() {
        return OptionalUtils.firstPresent(this.fromSystemSettings(), new Supplier[]{() -> this.fromProfileFile(this.profileFile, this.profileName)}).orElseGet(this::fromDefaultChecksumValidation);
    }

    private Optional<ResponseChecksumValidation> fromSystemSettings() {
        return SdkSystemSetting.AWS_RESPONSE_CHECKSUM_VALIDATION.getStringValue().flatMap(this::stringToEnum);
    }

    private Optional<ResponseChecksumValidation> fromProfileFile(Supplier<ProfileFile> profileFile, String profileName) {
        return profileFile.get().profile(profileName).flatMap(p -> p.property("response_checksum_validation")).flatMap(this::stringToEnum);
    }

    private ResponseChecksumValidation fromDefaultChecksumValidation() {
        return this.defaultChecksumValidation != null ? this.defaultChecksumValidation : SDK_DEFAULT_CHECKSUM_VALIDATION;
    }

    private Optional<ResponseChecksumValidation> stringToEnum(String value) {
        return Optional.of(ResponseChecksumValidation.fromValue(value));
    }
}

