/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultAsyncResponseTransformerSplitResult<ResponseT, ResultT>
implements AsyncResponseTransformer.SplitResult<ResponseT, ResultT> {
    private final SdkPublisher<AsyncResponseTransformer<ResponseT, ResponseT>> publisher;
    private final CompletableFuture<ResultT> future;

    private DefaultAsyncResponseTransformerSplitResult(AsyncResponseTransformer.SplitResult.Builder<ResponseT, ResultT> builder) {
        this.publisher = Validate.paramNotNull(builder.publisher(), "asyncResponseTransformerPublisher");
        this.future = Validate.paramNotNull(builder.resultFuture(), "future");
    }

    @Override
    public SdkPublisher<AsyncResponseTransformer<ResponseT, ResponseT>> publisher() {
        return this.publisher;
    }

    @Override
    public CompletableFuture<ResultT> resultFuture() {
        return this.future;
    }

    @Override
    public AsyncResponseTransformer.SplitResult.Builder<ResponseT, ResultT> toBuilder() {
        return new DefaultBuilder(this);
    }

    public static <ResponseT, ResultT> DefaultBuilder<ResponseT, ResultT> builder() {
        return new DefaultBuilder();
    }

    public static class DefaultBuilder<ResponseT, ResultT>
    implements AsyncResponseTransformer.SplitResult.Builder<ResponseT, ResultT> {
        private SdkPublisher<AsyncResponseTransformer<ResponseT, ResponseT>> publisher;
        private CompletableFuture<ResultT> future;

        DefaultBuilder() {
        }

        DefaultBuilder(DefaultAsyncResponseTransformerSplitResult<ResponseT, ResultT> split) {
            this.publisher = ((DefaultAsyncResponseTransformerSplitResult)split).publisher;
            this.future = ((DefaultAsyncResponseTransformerSplitResult)split).future;
        }

        @Override
        public SdkPublisher<AsyncResponseTransformer<ResponseT, ResponseT>> publisher() {
            return this.publisher;
        }

        @Override
        public AsyncResponseTransformer.SplitResult.Builder<ResponseT, ResultT> publisher(SdkPublisher<AsyncResponseTransformer<ResponseT, ResponseT>> publisher) {
            this.publisher = publisher;
            return this;
        }

        @Override
        public CompletableFuture<ResultT> resultFuture() {
            return this.future;
        }

        @Override
        public AsyncResponseTransformer.SplitResult.Builder<ResponseT, ResultT> resultFuture(CompletableFuture<ResultT> future) {
            this.future = future;
            return this;
        }

        @Override
        public AsyncResponseTransformer.SplitResult<ResponseT, ResultT> build() {
            return new DefaultAsyncResponseTransformerSplitResult(this);
        }
    }
}

