/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.pipeline.MutableRequestToRequestPipeline;
import software.amazon.awssdk.core.internal.useragent.UserAgentConstant;
import software.amazon.awssdk.core.useragent.AdditionalMetadata;
import software.amazon.awssdk.core.useragent.BusinessMetricCollection;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public class ApplyUserAgentStage
implements MutableRequestToRequestPipeline {
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String SDK_METRICS = "sdk-metrics";
    private static final Logger log = Logger.loggerFor(ApplyUserAgentStage.class);
    private final SdkClientConfiguration clientConfig;

    public ApplyUserAgentStage(HttpClientDependencies dependencies) {
        this.clientConfig = dependencies.clientConfiguration();
    }

    @Override
    public SdkHttpFullRequest.Builder execute(SdkHttpFullRequest.Builder request, RequestExecutionContext context) throws Exception {
        String headerValue = this.finalizeUserAgent(context);
        return request.putHeader(HEADER_USER_AGENT, headerValue);
    }

    private String finalizeUserAgent(RequestExecutionContext context) {
        String clientUserAgent = this.clientConfig.option(SdkClientOption.CLIENT_USER_AGENT);
        if (clientUserAgent == null) {
            log.warn(() -> "Client user agent configuration is missing, so request user agent will be incomplete.");
            clientUserAgent = "";
        }
        Pair<List<ApiName>, Collection<String>> groupedApiNames = ApplyUserAgentStage.groupApiNames(context.requestConfig().apiNames());
        StringBuilder javaUserAgent = new StringBuilder();
        String userPrefix = StringUtils.trim(this.clientConfig.option(SdkAdvancedClientOption.USER_AGENT_PREFIX));
        if (!StringUtils.isEmpty(userPrefix)) {
            javaUserAgent.append(userPrefix).append(" ");
        }
        javaUserAgent.append(clientUserAgent);
        List<AdditionalMetadata> userAgentMetadata = context.executionAttributes().getAttribute(SdkInternalExecutionAttribute.USER_AGENT_METADATA);
        if (userAgentMetadata != null) {
            userAgentMetadata.forEach(s -> javaUserAgent.append(" ").append(s));
        }
        Optional<String> businessMetrics = ApplyUserAgentStage.getBusinessMetricsString(context.executionAttributes(), groupedApiNames.right());
        businessMetrics.ifPresent(metrics -> UserAgentConstant.appendSpaceAndField(javaUserAgent, "m", metrics));
        Optional<String> apiNames = this.requestApiNames(groupedApiNames.left());
        apiNames.ifPresent(javaUserAgent::append);
        String userSuffix = StringUtils.trim(this.clientConfig.option(SdkAdvancedClientOption.USER_AGENT_SUFFIX));
        if (!StringUtils.isEmpty(userSuffix)) {
            javaUserAgent.append(" ").append(userSuffix);
        }
        return javaUserAgent.toString();
    }

    private static Pair<List<ApiName>, Collection<String>> groupApiNames(List<ApiName> input) {
        ArrayList<ApiName> customApiNames = new ArrayList<ApiName>();
        ArrayList<String> metricsFromApiNames = new ArrayList<String>();
        for (ApiName requestApiName : input) {
            if (requestApiName.name().equals(SDK_METRICS)) {
                metricsFromApiNames.add(requestApiName.version());
                continue;
            }
            customApiNames.add(requestApiName);
        }
        return Pair.of(customApiNames, metricsFromApiNames);
    }

    private static Optional<String> getBusinessMetricsString(ExecutionAttributes executionAttributes, Collection<String> metricsFromApiNames) {
        BusinessMetricCollection businessMetrics = executionAttributes.getAttribute(SdkInternalExecutionAttribute.BUSINESS_METRICS);
        if (businessMetrics == null) {
            businessMetrics = new BusinessMetricCollection();
        }
        businessMetrics.merge(metricsFromApiNames);
        ApplyUserAgentStage.credentialProviderBusinessMetrics(executionAttributes).ifPresent(businessMetrics::merge);
        if (businessMetrics.recordedMetrics().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(businessMetrics.asBoundedString());
    }

    private static Optional<Collection<String>> credentialProviderBusinessMetrics(ExecutionAttributes executionAttributes) {
        return Optional.ofNullable(executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME)).map(selectedAuthScheme -> (Identity)CompletableFutureUtils.joinLikeSync(selectedAuthScheme.identity())).flatMap(Identity::providerName).map(providerName -> {
            if (StringUtils.isBlank(providerName)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(providerName);
        });
    }

    private Optional<String> requestApiNames(List<ApiName> requestApiNames) {
        if (requestApiNames.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder concatenatedNames = new StringBuilder();
        requestApiNames.forEach(apiName -> concatenatedNames.append(" ").append(apiName.name()).append("/").append(apiName.version()));
        return Optional.of(concatenatedNames.toString());
    }
}

