/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.retry;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.internal.retry.RetryPolicyAdapter;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.RetryUtils;
import software.amazon.awssdk.retries.AdaptiveRetryStrategy;
import software.amazon.awssdk.retries.DefaultRetryStrategy;
import software.amazon.awssdk.retries.LegacyRetryStrategy;
import software.amazon.awssdk.retries.StandardRetryStrategy;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.retries.internal.DefaultAwareRetryStrategy;
import software.amazon.awssdk.retries.internal.RetryStrategyDefaults;

@SdkPublicApi
public final class SdkDefaultRetryStrategy {
    private static final String DEFAULTS_NAME = "sdk";
    private static final RetryStrategyDefaults DEFAULTS_PREDICATES = new RetryStrategyDefaults(){

        @Override
        public String name() {
            return SdkDefaultRetryStrategy.DEFAULTS_NAME;
        }

        @Override
        public void applyDefaults(RetryStrategy.Builder<?, ?> builder) {
            SdkDefaultRetryStrategy.configureStrategy(builder);
            SdkDefaultRetryStrategy.markDefaultsAdded(builder);
        }
    };

    private SdkDefaultRetryStrategy() {
    }

    public static RetryStrategy defaultRetryStrategy() {
        return SdkDefaultRetryStrategy.forRetryMode(RetryMode.defaultRetryMode());
    }

    public static RetryStrategy forRetryMode(RetryMode mode) {
        switch (mode) {
            case STANDARD: {
                return SdkDefaultRetryStrategy.standardRetryStrategy();
            }
            case ADAPTIVE: {
                return SdkDefaultRetryStrategy.legacyAdaptiveRetryStrategy();
            }
            case ADAPTIVE_V2: {
                return SdkDefaultRetryStrategy.adaptiveRetryStrategy();
            }
            case LEGACY: {
                return SdkDefaultRetryStrategy.legacyRetryStrategy();
            }
        }
        throw new IllegalStateException("unknown retry mode: " + (Object)((Object)mode));
    }

    public static RetryMode retryMode(RetryStrategy retryStrategy) {
        if (retryStrategy instanceof StandardRetryStrategy) {
            return RetryMode.STANDARD;
        }
        if (retryStrategy instanceof AdaptiveRetryStrategy) {
            return RetryMode.ADAPTIVE_V2;
        }
        if (retryStrategy instanceof LegacyRetryStrategy) {
            return RetryMode.LEGACY;
        }
        if (retryStrategy instanceof RetryPolicyAdapter) {
            return RetryMode.ADAPTIVE;
        }
        throw new IllegalArgumentException("unknown retry strategy class: " + retryStrategy.getClass().getName());
    }

    public static StandardRetryStrategy standardRetryStrategy() {
        return SdkDefaultRetryStrategy.standardRetryStrategyBuilder().build();
    }

    public static LegacyRetryStrategy legacyRetryStrategy() {
        return SdkDefaultRetryStrategy.legacyRetryStrategyBuilder().build();
    }

    public static AdaptiveRetryStrategy adaptiveRetryStrategy() {
        return SdkDefaultRetryStrategy.adaptiveRetryStrategyBuilder().build();
    }

    public static StandardRetryStrategy.Builder standardRetryStrategyBuilder() {
        StandardRetryStrategy.Builder builder = DefaultRetryStrategy.standardStrategyBuilder();
        return SdkDefaultRetryStrategy.configure(builder);
    }

    public static LegacyRetryStrategy.Builder legacyRetryStrategyBuilder() {
        LegacyRetryStrategy.Builder builder = DefaultRetryStrategy.legacyStrategyBuilder();
        return SdkDefaultRetryStrategy.configure(builder);
    }

    public static AdaptiveRetryStrategy.Builder adaptiveRetryStrategyBuilder() {
        AdaptiveRetryStrategy.Builder builder = DefaultRetryStrategy.adaptiveStrategyBuilder();
        return SdkDefaultRetryStrategy.configure(builder);
    }

    public static <T extends RetryStrategy.Builder<T, ?>> T configure(T builder) {
        builder.retryOnException(SdkDefaultRetryStrategy::retryOnRetryableException).retryOnException(SdkDefaultRetryStrategy::retryOnStatusCodes).retryOnException(SdkDefaultRetryStrategy::retryOnClockSkewException).retryOnException(SdkDefaultRetryStrategy::retryOnThrottlingCondition);
        SdkDefaultRetrySetting.RETRYABLE_EXCEPTIONS.forEach(builder::retryOnExceptionOrCauseInstanceOf);
        builder.treatAsThrottling(SdkDefaultRetryStrategy::treatAsThrottling);
        Integer maxAttempts = SdkSystemSetting.AWS_MAX_ATTEMPTS.getIntegerValue().orElse(null);
        if (maxAttempts != null) {
            builder.maxAttempts(maxAttempts);
        }
        if (builder instanceof DefaultAwareRetryStrategy.Builder) {
            DefaultAwareRetryStrategy.Builder b = (DefaultAwareRetryStrategy.Builder)((Object)builder);
            b.markDefaultAdded(DEFAULTS_NAME);
        }
        return builder;
    }

    public static RetryStrategy.Builder<?, ?> configureStrategy(RetryStrategy.Builder<?, ?> builder) {
        builder.retryOnException(SdkDefaultRetryStrategy::retryOnRetryableException).retryOnException(SdkDefaultRetryStrategy::retryOnStatusCodes).retryOnException(SdkDefaultRetryStrategy::retryOnClockSkewException).retryOnException(SdkDefaultRetryStrategy::retryOnThrottlingCondition);
        SdkDefaultRetrySetting.RETRYABLE_EXCEPTIONS.forEach(builder::retryOnExceptionOrCauseInstanceOf);
        builder.treatAsThrottling(SdkDefaultRetryStrategy::treatAsThrottling);
        return builder;
    }

    private static boolean treatAsThrottling(Throwable t) {
        if (t instanceof SdkException) {
            return RetryUtils.isThrottlingException((SdkException)t);
        }
        return false;
    }

    private static boolean retryOnRetryableException(Throwable ex) {
        if (ex instanceof SdkException) {
            return RetryUtils.isRetryableException((SdkException)ex);
        }
        return false;
    }

    private static boolean retryOnStatusCodes(Throwable ex) {
        if (ex instanceof SdkServiceException) {
            SdkServiceException failure = (SdkServiceException)ex;
            return SdkDefaultRetrySetting.RETRYABLE_STATUS_CODES.contains(failure.statusCode());
        }
        return false;
    }

    private static boolean retryOnClockSkewException(Throwable ex) {
        if (ex instanceof SdkException) {
            return RetryUtils.isClockSkewException((SdkException)ex);
        }
        return false;
    }

    private static boolean retryOnThrottlingCondition(Throwable ex) {
        if (ex instanceof SdkException) {
            return RetryUtils.isThrottlingException((SdkException)ex);
        }
        return false;
    }

    private static RetryStrategy legacyAdaptiveRetryStrategy() {
        return RetryPolicyAdapter.builder().retryPolicy(RetryPolicy.forRetryMode(RetryMode.ADAPTIVE)).build();
    }

    public static RetryStrategyDefaults retryStrategyDefaults() {
        return DEFAULTS_PREDICATES;
    }

    private static void markDefaultsAdded(RetryStrategy.Builder<?, ?> builder) {
        if (builder instanceof DefaultAwareRetryStrategy.Builder) {
            DefaultAwareRetryStrategy.Builder b = (DefaultAwareRetryStrategy.Builder)((Object)builder);
            b.markDefaultAdded(DEFAULTS_NAME);
        }
    }
}

