/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.internal.scheme;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4aAuthScheme;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;

@SdkInternalApi
public final class DefaultAwsV4aAuthScheme
implements AwsV4aAuthScheme {
    private static final DefaultAwsV4aAuthScheme DEFAULT = new DefaultAwsV4aAuthScheme();

    public static DefaultAwsV4aAuthScheme create() {
        return DEFAULT;
    }

    @Override
    public String schemeId() {
        return "aws.auth#sigv4a";
    }

    @Override
    public IdentityProvider<AwsCredentialsIdentity> identityProvider(IdentityProviders providers) {
        return providers.identityProvider(AwsCredentialsIdentity.class);
    }

    @Override
    public AwsV4aHttpSigner signer() {
        if (SignerSingletonHolder.ERROR != null) {
            throw SignerSingletonHolder.ERROR;
        }
        return SignerSingletonHolder.INSTANCE;
    }

    private static class SignerSingletonHolder {
        private static final AwsV4aHttpSigner INSTANCE;
        private static final RuntimeException ERROR;

        private SignerSingletonHolder() {
        }

        static {
            AwsV4aHttpSigner instance = null;
            RuntimeException error = null;
            try {
                instance = AwsV4aHttpSigner.create();
            }
            catch (RuntimeException e) {
                error = e;
            }
            INSTANCE = instance;
            ERROR = error;
        }
    }
}

