/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.jsoncore;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonValueNodeFactory;
import software.amazon.awssdk.protocols.jsoncore.internal.ArrayJsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.EmbeddedObjectJsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.ObjectJsonNode;
import software.amazon.awssdk.thirdparty.jackson.core.JsonFactory;
import software.amazon.awssdk.thirdparty.jackson.core.JsonParseException;
import software.amazon.awssdk.thirdparty.jackson.core.JsonParser;
import software.amazon.awssdk.thirdparty.jackson.core.JsonToken;
import software.amazon.awssdk.thirdparty.jackson.core.StreamReadFeature;
import software.amazon.awssdk.thirdparty.jackson.core.TSFBuilder;
import software.amazon.awssdk.thirdparty.jackson.core.json.JsonReadFeature;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkProtectedApi
public final class JsonNodeParser {
    public static final JsonFactory DEFAULT_JSON_FACTORY = ((TSFBuilder)((TSFBuilder)JsonFactory.builder().enable(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION)).configure(JsonReadFeature.ALLOW_JAVA_COMMENTS, true)).build();
    private final boolean removeErrorLocations;
    private final JsonFactory jsonFactory;
    private final JsonValueNodeFactory jsonValueNodeFactory;

    private JsonNodeParser(Builder builder) {
        this.removeErrorLocations = builder.removeErrorLocations;
        this.jsonFactory = builder.jsonFactory;
        this.jsonValueNodeFactory = builder.jsonValueNodeFactory;
    }

    public static JsonNodeParser create() {
        return JsonNodeParser.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public JsonNode parse(InputStream content) {
        return FunctionalUtils.invokeSafely(() -> {
            try (JsonParser parser = this.jsonFactory.createParser(content).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);){
                JsonNode jsonNode = this.parse(parser);
                return jsonNode;
            }
        });
    }

    public JsonNode parse(byte[] content) {
        return FunctionalUtils.invokeSafely(() -> {
            try (JsonParser parser = this.jsonFactory.createParser(content).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);){
                JsonNode jsonNode = this.parse(parser);
                return jsonNode;
            }
        });
    }

    public JsonNode parse(String content) {
        return FunctionalUtils.invokeSafely(() -> {
            try (JsonParser parser = this.jsonFactory.createParser(content).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);){
                JsonNode jsonNode = this.parse(parser);
                return jsonNode;
            }
        });
    }

    private JsonNode parse(JsonParser parser) throws IOException {
        try {
            return this.parseToken(parser, parser.nextToken());
        }
        catch (Exception e) {
            this.removeErrorLocationsIfRequired(e);
            throw e;
        }
    }

    private void removeErrorLocationsIfRequired(Throwable exception) {
        if (this.removeErrorLocations) {
            this.removeErrorLocations(exception);
        }
    }

    private void removeErrorLocations(Throwable exception) {
        if (exception == null) {
            return;
        }
        if (exception instanceof JsonParseException) {
            ((JsonParseException)exception).clearLocation();
        }
        this.removeErrorLocations(exception.getCause());
    }

    private JsonNode parseToken(JsonParser parser, JsonToken token) throws IOException {
        if (token == null) {
            return null;
        }
        switch (token) {
            case VALUE_STRING: 
            case VALUE_FALSE: 
            case VALUE_TRUE: 
            case VALUE_NULL: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return this.jsonValueNodeFactory.node(parser, token);
            }
            case START_OBJECT: {
                return this.parseObject(parser);
            }
            case START_ARRAY: {
                return this.parseArray(parser);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return new EmbeddedObjectJsonNode(parser.getEmbeddedObject());
            }
        }
        throw new IllegalArgumentException("Unexpected JSON token - " + (Object)((Object)token));
    }

    private JsonNode parseObject(JsonParser parser) throws IOException {
        JsonToken currentToken = parser.nextToken();
        LinkedHashMap<String, JsonNode> object = new LinkedHashMap<String, JsonNode>();
        while (currentToken != JsonToken.END_OBJECT) {
            String fieldName = parser.getText();
            object.put(fieldName, this.parseToken(parser, parser.nextToken()));
            currentToken = parser.nextToken();
        }
        return new ObjectJsonNode(object);
    }

    private JsonNode parseArray(JsonParser parser) throws IOException {
        JsonToken currentToken = parser.nextToken();
        ArrayList<JsonNode> array = new ArrayList<JsonNode>();
        while (currentToken != JsonToken.END_ARRAY) {
            array.add(this.parseToken(parser, currentToken));
            currentToken = parser.nextToken();
        }
        return new ArrayJsonNode(array);
    }

    public static final class Builder {
        private JsonFactory jsonFactory = DEFAULT_JSON_FACTORY;
        private JsonValueNodeFactory jsonValueNodeFactory = JsonValueNodeFactory.DEFAULT;
        private boolean removeErrorLocations = false;

        private Builder() {
        }

        public Builder removeErrorLocations(boolean removeErrorLocations) {
            this.removeErrorLocations = removeErrorLocations;
            return this;
        }

        public Builder jsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        public Builder jsonValueNodeFactory(JsonValueNodeFactory jsonValueNodeFactory) {
            this.jsonValueNodeFactory = jsonValueNodeFactory;
            return this;
        }

        public JsonNodeParser build() {
            return new JsonNodeParser(this);
        }
    }
}

