/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.jsoncore;

import java.io.IOException;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.BooleanJsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.EmbeddedObjectJsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.NullJsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.NumberJsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.StringJsonNode;
import software.amazon.awssdk.thirdparty.jackson.core.JsonParser;
import software.amazon.awssdk.thirdparty.jackson.core.JsonToken;

@SdkProtectedApi
public interface JsonValueNodeFactory {
    public static final JsonValueNodeFactory DEFAULT = (parser, token) -> {
        switch (token) {
            case VALUE_STRING: {
                return new StringJsonNode(parser.getText());
            }
            case VALUE_FALSE: {
                return new BooleanJsonNode(false);
            }
            case VALUE_TRUE: {
                return new BooleanJsonNode(true);
            }
            case VALUE_NULL: {
                return NullJsonNode.instance();
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return new NumberJsonNode(parser.getText());
            }
            case VALUE_EMBEDDED_OBJECT: {
                return new EmbeddedObjectJsonNode(parser.getEmbeddedObject());
            }
        }
        throw new IllegalArgumentException("Unexpected JSON token - " + (Object)((Object)token));
    };

    public JsonNode node(JsonParser var1, JsonToken var2) throws IOException;
}

