/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class DaciaServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "dacia";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("ap-east-1"), Region.of("ap-east-2"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-northeast-3"), Region.of("ap-south-1"), Region.of("ap-south-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ap-southeast-3"), Region.of("ap-southeast-4"), Region.of("ap-southeast-5"), Region.of("ap-southeast-6"), Region.of("ap-southeast-7"), Region.of("ca-central-1"), Region.of("ca-west-1"), Region.of("eu-central-1"), Region.of("eu-central-2"), Region.of("eu-north-1"), Region.of("eu-south-1"), Region.of("eu-south-2"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("il-central-1"), Region.of("me-central-1"), Region.of("me-south-1"), Region.of("me-west-1"), Region.of("mx-central-1"), Region.of("sa-east-1"), Region.of("sa-west-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-northeast-1"), Region.of("us-west-1"), Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1"), Region.of("us-iso-east-1"), Region.of("us-iso-west-1"), Region.of("us-isob-east-1"), Region.of("us-isob-west-1"), Region.of("eu-isoe-west-1"), Region.of("us-isof-east-1"), Region.of("us-isof-south-1"), Region.of("eusc-de-east-1"), Region.of("ap-isog-east-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null), new DefaultServicePartitionMetadata("aws-iso-b", null), new DefaultServicePartitionMetadata("aws-iso-e", null), new DefaultServicePartitionMetadata("aws-iso-f", null), new DefaultServicePartitionMetadata("aws-eusc", null), new DefaultServicePartitionMetadata("aws-iso-g", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().allowDuplicateKeys(true).put(ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), "daciaservice.cpt.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-east-1")).build(), "daciaservice.hkg.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-east-2")).build(), "daciaservice.tpe.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), "daciaservice.nrt.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), "daciaservice.icn.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).build(), "daciaservice.kix.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), "daciaservice.bom.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), "daciaservice.hyd.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), "daciaservice.sin.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), "daciaservice.syd.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).build(), "daciaservice.cgk.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).build(), "daciaservice.mel.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).build(), "daciaservice.kul.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).build(), "daciaservice.akl.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).build(), "daciaservice.bkk.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), "daciaservice.yul.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), "daciaservice.yyc.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), "daciaservice.fra.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("eu-central-2")).build(), "daciaservice.zrh.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), "daciaservice.arn.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("eu-south-1")).build(), "daciaservice.mxp.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), "daciaservice.zaz.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), "daciaservice.dub.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), "daciaservice.lhr.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), "daciaservice.cdg.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("il-central-1")).build(), "daciaservice.tlv.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), "daciaservice.dxb.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), "daciaservice.bah.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("me-west-1")).build(), "daciaservice.ruh.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("mx-central-1")).build(), "daciaservice.qro.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), "daciaservice.gru.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("sa-west-1")).build(), "daciaservice.scl.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), "daciaservice.iad.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), "daciaservice.cmh.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-northeast-1")).build(), "daciaservice.mdw.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), "daciaservice.sfo.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), "daciaservice.pdx.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), "daciaservice.bjs.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(), "daciaservice.zhy.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("eusc-de-east-1")).build(), "daciaservice.thf.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).build(), "daciaservice.dca.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-iso-west-1")).build(), "daciaservice.apa.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).build(), "daciaservice.lck.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-isob-west-1")).build(), "daciaservice.ffz.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("eu-isoe-west-1")).build(), "daciaservice.ncl.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-isof-east-1")).build(), "daciaservice.ltw.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(), "daciaservice.ale.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("ap-isog-east-1")).build(), "daciaservice.abx.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), "daciaservice.osu.amazon.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), "daciaservice.pdt.amazon.com").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

